<?php

namespace App;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;

use Request;

class ArticleAuthor extends Model
{

    use Sluggable;

    protected $fillable = [
        'firstname',
        'lastname',
        'title',
        'bio',
        'email',
    ];

    public function getRouteKeyName()
    {

        return 'slug';
    }

    public function sluggable()
    {

        return [
            'slug' => [
                'source' => ['firstname', 'lastname'],
            ],
        ];
    }

    /**
     *
     *
     *
     *
     *
     * RELATIONSHIPS
     *
     *
     *
     *
     *
     */

    public function articleAuthorImages()
    {

        return $this->hasMany('App\ArticleAuthorImage');
    }

    public function articles()
    {

        return $this->hasMany('App\Article');
    }

    /**
     *
     *
     *
     *
     *
     * GETTERS
     *
     *
     *
     *
     *
     */

    public function getFullNameAttribute()
    {
        
        return $this->firstname . ' ' . $this->lastname;
    }

    public function getLinkAttribute()
    {

        return Request::root() . '/author/' . $this->slug;
    }

    public function getImageAttribute()
    {

        return $this->articleAuthorImages->first();
    }
}
