<?php

namespace App;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;


class ArticleCategory extends Model
{
    use Sluggable;

    protected $fillable = [
        'title',
        'name',
        'order',
        'article_type_id',
    ];

    public $timestamps = false;

    public function sluggable()
    {

        return [
            'slug' => [
                'source' => 'title'
            ],
        ];
    }

    /**
     *
     *
     *
     *
     *
     * RELATIONSHIPS
     *
     *
     *
     *
     *
     */

    public function articles()
    {

        return $this->hasMany('App\Article');
    }

    public function articleType()
    {

        return $this->belongsTo('App\ArticleType');
    }

    /**
     *
     *
     *
     *
     *
     *
     * GETTERS
     *
     *
     *
     *
     *
     *
     */

    /**
     * Get href Link
     *
     * @return string
     */
    public function getLinkAttribute()
    {

        return '/' . $this->slug;
    }

    /**
     *
     *
     *
     *
     *
     *
     * SETTERS
     *
     *
     *
     *
     *
     *
     */

    public function setSlugAttribute()
    {
    }
}
