<?php namespace App;

use Illuminate\Database\Eloquent\Model;

use Request;

class ArticleImage extends Model
{

   

    protected $fillable = [
        'source',
        'alternate_text',
        'caption',
        'article_image_type_id',
        'width',
        'height',
    ];

    public function article()
    {

        return $this->belongsToMany('App\Article');
    }

    public function articleImageType()
    {

        return $this->belongsTo('App\ArticleImageType');
    }

    public function scopeType($query, $type)
    {

        //turn type into an array if it isn't one already
        $type = is_array($type) ? $type : [$type];

        //use whereIn to find either one or many different types to return
        return $query->whereIn('articleImageType.name', $type);
    }

    /**
     * Used by the Newsletter to create a link for the article
     *
     * @return string
     */
    public function getLinkAttribute()
    {

        return Request::root() . $this->source;
    }
}
