<?php

namespace App;

use Illuminate\Database\Eloquent\Model;


class ArticleMagazineEdition extends Model
{

    

    protected $fillable = [
        'link',
        'year',
        'print_image', 
        'article_image',
        'published_at',
        'article_magazine_month_id',
		'title',
		'cs_title',
		'cs_sub_title',
		'cs_author',
		'ei_title',
		'ei_sub_title',
		'ei_author',
		
    ];

    public function articleMagazineMonth()
    {

        return $this->belongsTo('App\ArticleMagazineMonth');
    }

    public function articles()
    {

        return $this->hasMany('App\Article');
    }

    public function getFullEditionDateAttribute()
    {

        return $this->year . ' - ' . $this->articleMagazineMonth->name;
    }
    public function getFullEditionTableNameAttribute()
    {

        return '#' . $this->year . '-' . $this->articleMagazineMonth->start_date . '#' . implode('_', explode('/', $this->articleMagazineMonth->name));
    }
}
