<?php namespace App;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;


class ArticleType extends Model
{

    use Sluggable;

    const EDITORIAL = 4;
    const BLOG = 6;
    const PODCAST = 8;
    
    protected $fillable = [
        'name',
        'title',
    ];
    
    public $timestamps = false;

    public function sluggable()
    {

        return [
            'slug' => [
                'source' => 'title',
            ],
        ];
    }

    public function articles()
    {

        return $this->hasMany('App\Article');
    }

    public function articleCategories()
    {

        return $this->hasMany('App\ArticleCategory');
    }

    public function scopeName($query, $name)
    {

        return $query->whereName($name);
    }
}
