<?php

namespace App;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;


class Banner extends Model
{
    use Sluggable;

    protected $fillable
        = [
            'active',
            'company',
            'line_item',
            'link',
            'source',
            'width',
            'height',
            'banner_type_id',
        ];

    public function sluggable()
    {

        return [
            'slug' => [
                'source' => ['company', 'line_item'],
            ],
        ];
    }

    /**
     *
     *
     *
     *
     *
     * RELATIONSHIPS
     *
     *
     *
     *
     *
     */

    public function newsletters()
    {

        return $this->belongsToMany('App\Newsletter');
    }

    public function bannerType()
    {

        return $this->belongsTo('App\BannerType');
    }

    /**
     *
     *
     *
     *
     *
     * SCOPES
     *
     *
     *
     *
     *
     */

    public function scopeBannerBySlug($query, $slug)
    {

        return $query->where('slug', $slug)->first();
    }

    public function scopeBannerListByBannerType($query, $banner_type)
    {

        return $query->whereHas('bannerType', function ($query) use ($banner_type) {

            $query->where('slug', $banner_type);
        })->get();
    }

    public function scopeBannerById($query, $id)
    {

        return $query->where('id', $id)->first();
    }

    /**
     *
     *
     *
     *
     *
     * GETTERS
     *
     *
     *
     *
     *
     */

    public function getWidthAttribute()
    {

        return $this->bannerType->width;
    }

    public function getHeightAttribute()
    {

        return $this->bannerType->width;
    }

    /**
     *
     *
     *
     *
     *
     * SETTERS
     *
     *
     *
     *
     *
     */

    public function setLinkAttribute($link)
    {

        $this->attributes['link'] = trim($link);
    }
}
