<?php
namespace App\Components;
use Nayjest\Grids\Components\Tr;

class GridTr extends Tr
{
    public function getTagName()
    {
        return 'tr';
    }

    public function getAttributes()
    {
        // Get value of 'id' column from current row
        $id = $this->getDataRow()->getCellValue('id');
        $slug = $this->getDataRow()->getCellValue('slug');

        if (strpos(\Request::path(), 'admin') !== false) {
            $url = explode('/admin', \Request::path())[0];
        } else {
            $url = \Request::path();
        }
        // Prepare custom attributes
        $newAttributes = [
             'class' => 'edit_data',
             'data-id' => $id,
             'data-path' => '/' . $url . '/' . $slug . '/edit',
             'style' => 'cursor: pointer;'
        ];
        return array_merge(parent::getAttributes(), $newAttributes);
    }
}
