<?php
namespace App\Components;
use Nayjest\Grids\Components\Tr;

class GridTrById extends Tr
{
    public function getTagName()
    {
        return 'tr';
    }

    public function getAttributes()
    {
        // Get value of 'id' column from current row
        $id = $this->getDataRow()->getCellValue('id');
        $path = \Request::path();

        if (strpos(\Request::path(), '/admin') !== false) {
            $path = explode('/', \Request::path())[0];
        }
        // Prepare custom attributes
        $newAttributes = [
             'class' => 'edit_data',
             'data-id' => $id,
             'data-path' => '/' . $path . '/' . $id . '/edit',
             'style' => 'cursor: pointer;'
        ];
        return array_merge(parent::getAttributes(), $newAttributes);
    }
}
