<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use Geocode;

use Request;

class Directory extends Model
{

    use Sluggable;

    protected $fillable = [
        'company',
        'phone',
        'fax',
        'website',
        'street',
        'city',
        'region',
        'country',
        'description',
        'latitude',
        'longitude',
        'logo',
        'hotline',
        'postal_code',
        'email',
        'slug',
    ];

    /**
     * @return string
     */
    public function getRouteKeyName()
    {

        return 'slug';
    }

    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable()
    {

        return [
            'slug' => [
                'source' => 'company',
            ],
        ];
    }

    /**
     *
     */
    public function setLatitudeAttribute()
    {
        if ($this->street != '' && $this->city != '' && $this->region != '' && $this->country != '' && $this->postal_code != '') {
            $this->attributes['latitude'] = $this->geocode->latitude();
        } else {
            $this->attributes['latitude'] = '';
        }
    }

    /**
     *
     */
    public function setLongitudeAttribute()
    {
        if ($this->street != '' && $this->city != '' && $this->region != '' && $this->country != '' && $this->postal_code != '') {
            $this->attributes['longitude'] = $this->geocode->longitude();
        } else {
            $this->attributes['longitude'] = '';
        }
    }

    /**
     * @return mixed
     */
    public function getAddressAttribute()
    {

        return $this->street . ($this->city ? ', ' . $this->city : '') . ($this->region ? ', ' . $this->region : '') . ($this->country ? ', ' . $this->country : '') . ($this->postal_code ? ', ' . $this->postal_code : '');
    }

    public function getGeoCodeAttribute()
    {
        return Geocode::make()->address($this->street . ' ' . $this->city . ' ' . $this->region . ' ' . $this->country . ' ' . $this->postal_code);
    }


    /**
     * Used by the Newsletter to create a link for the article
     *
     * @return string
     */
    public function getLinkAttribute()
    {

        return Request::root() . '/directory/' . $this->slug;
    }
}
