<?php namespace App\Http\Controllers;

use App\Article;

use Excel;

use App\ArticleAuthor;
use App\ArticleCategory;
use App\ArticleMagazineEdition;
use App\ArticleSlugRedirect;
use App\ArticleTitleTag;
use App\ArticleType;
use App\AnaliyticsView;
use App\Subscriber;
use App\SubscriberRegion;
use App\Http\Requests\ArticleRequest;
use App\Marex\Reports\ArticleReport;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Http\Request;
use Auth;
use Log;
use Redirect;
use Carbon\Carbon;

class AdditionalController extends Controller
{

    public function __construct()
    {

        $this->middleware('auth', [
            'except' => [
                'remove'
            ],
        ]);
    }

    /**
     * Export Excel top 100 articles (everything other than corporate news) posted since January 1 2018.
     *
     * @return Excel
     */
    public function export($count, $start_date)
    {
        $articles = Article::whereDate('published_at', '>=', Carbon::parse($start_date))
                            ->where('article_type_id', '!=', 2)
                            ->orderBy('views', 'desc')->limit($count)
                            ->get(['title','views','slug','article_type_id']);

        Excel::create('top_100_articles', function ($excel) use ($articles) {

            $excel->sheet('Top 100 Articles', function ($sheet) use ($articles) {

                //setup the header titles
                $title_array = [
                    'Title',
                    'Full URL',
                    'Article Type',
                    'Views',
                ];

                $sheet->fromArray($title_array, null, 'A1');

                $articles->each(function ($article, $key) use ($sheet) {
                    $key += 2;

                    $sheet->cell('A' . $key, $article->title);
                    $sheet->cell('B' . $key, $article->link);
                    $sheet->cell('C' . $key, (is_null($article->articleType) ? '' : $article->articleType->title));
                    $sheet->cell('D' . $key, $article->views);
                });
            });
        })->download('xlsx');
    }

    // Sync print magazine subscribers with Jan-Feb Laravel Galley - v10-Final .xlsx
    public function magazinelist()
    {
        $magazines = Subscriber::where('magazine', '=', 1)->where('status', '=', 0)->limit(1000)->get();

        foreach ($magazines as $item) {
            if ($record = \DB::table('mailing_list_print')
                ->where('id', $item->id)
                ->first()) {
                // echo "is in - ".$item->id." <br>";
                if (SubscriberRegion::where('code', '=', $record->region)->first()) {
                    $regionid = SubscriberRegion::where('code', '=', $record->region)->first()->id;
                } else {
                    $regionid = null;
                }
                $item->update([
                    'firstname' => $record->firstname,
                    'lastname' => $record->lastname,
                    'company' => $record->company,
                    'address_1' => $record->address_1,
                    'address_2' => $record->address_2,
                    'city' => $record->city,
                    'region' => $record->region,
                    'subscriber_region_id' => $regionid,
                    'postal_code' => $record->postal_code,
                    'country_id' => $record->country_id,
                    'start_date' => $record->start_date,
                    'end_date' => $record->end_date,
                    'status' => 1,
                ]);

                if ($item->newsletter != 1 && $item->digital != 1 && $item->email_marketing != 1 || ($item->newsletter == 1 || $item->digital == 1 || $item->email_marketing == 1) && filter_var($record->email, FILTER_VALIDATE_EMAIL)) {
                    $item->update([
                        'email' => $record->email
                    ]);
                }
            } elseif ($item->newsletter != 1 && $item->digital != 1 && $item->email_marketing != 1) {
                // echo "is not - delete ".$item->id."<br>";

                $item->delete();
            } else {
                // echo "is not  ".$item->id."<br>";

                $item->update([
                    'magazine' => 0,
                    'status' => 1
                ]);
            }
        }
        return Subscriber::where('magazine', '=', 1)->count() . ' - ' . Subscriber::where('magazine', '=', 1)->where('status', '=', 0)->count();
    }
}
