<?php namespace App\Http\Controllers;

use App\Article;

use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Http\Request;
use Auth;
use Log;
use Redirect;
use Carbon\Carbon;
use Analytics;
use Spatie\Analytics\Period;

class AnalyticsController extends Controller
{
    public function get()
    {

        $articles = Article::where('published_at', '!=', '0000-00-00 00:00:00')
                            ->where('published_at', '<=', Carbon::now()->toDateTimeString())
                            ->orderBy('published_at', 'DESC')
                            ->where('status', '=', '0')->limit(200)->get();

        $date = date_create("2008-03-24");

        foreach ($articles as $article) {
            if (strpos($article->slug, ',') === false && strpos($article->slug, ';') === false) {
                $articlelink = '/' . $article->articleType->slug . '/' . $article->slug;

                $analyticsData = Analytics::performQuery(
                    Period::create($date, Carbon::now()),
                    'ga:pageviews',
                    [
                        'dimensions' => 'ga:pagePath',
                        'filters' => 'ga:pagePath=@' . $articlelink
                    ]
                );

                $pageviewsData = collect($analyticsData['rows'] ?? [])->map(function (array $dateRow) {
                    return (int) $dateRow[1];
                });

                $pageviews = 0;
                foreach ($pageviewsData as $page) {
                    $pageviews += $page;
                }

                $article->views = $pageviews;
            }
            $article->status = '1';
            $article->save();
        }

        $count = Article::where('published_at', '!=', '0000-00-00 00:00:00')->where('published_at', '<=', Carbon::now()->toDateTimeString())->where('status', '=', '0')->count();

        return $count;
    }
}
