<?php namespace App\Http\Controllers;

use App\Article;
use App\ArticleAuthor;
use App\ArticleAuthorImage;
use App\Http\Requests;
use App\Http\Controllers\Controller;

use Grids;
use Nayjest\Grids\Components\FiltersRow;
use Nayjest\Grids\Components\Footer;
use Nayjest\Grids\Components\Header;
use Nayjest\Grids\Components\Pager;
use Nayjest\Grids\Components\RenderFunc;
use Nayjest\Grids\DataProvider;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\EloquentDataRow;
use Nayjest\Grids\FieldConfig;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\SelectFilterConfig;
use Nayjest\Grids\Grid;
use Nayjest\Grids\GridConfig;
use Nayjest\Grids\IdFieldConfig;
use Nayjest\Grids\ObjectDataRow;
use App\Components\GridTr;
use Nayjest\Grids\Components\ShowingRecords;
use Nayjest\Grids\Components\TFoot;
use Nayjest\Grids\Components\THead;
use Nayjest\Grids\Components\HtmlTag;
use Nayjest\Grids\Components\ColumnHeadersRow;
use Nayjest\Grids\Components\OneCellRow;
use Nayjest\Grids\Components\Base\RenderableRegistry;

use App\Http\Requests\ArticleAuthorRequest;
use App\Repositories\ArticleAuthorsRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class ArticleAuthorsController extends Controller
{
    protected $articleAuthorsRepository;

    public function __construct(ArticleAuthorsRepository $articleAuthorsRepository)
    {

        $this->middleware('auth', ['except' => ['show', 'moreArticles']]);
        $this->middleware('subscriber.cookie', ['only' => ['show']]);

        $this->articleAuthorsRepository = $articleAuthorsRepository;
    }

    /**
     *
     *
     *
     * CUSTOM ROUTE METHODS
     *
     *
     *
     */

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(Request $request)
    {
		
        //if a query exists from Scout get the string
        // $query = $request->input('query');

        //check if the query is empty if it isn't use the scout search method before paginating
        // $collection = empty($query) ? ArticleAuthor::orderBy('id', 'DESC')->paginate(10) : ArticleAuthor::search($query)->paginate(10);
        if (is_array($request->filter) && array_key_exists("sort", $request->filter) && $request->filter['sort']) {
            $query = ArticleAuthor::select('article_authors.*');
        } else {
            $query = ArticleAuthor::select('article_authors.*')
                ->orderBy('id', 'DESC');
        }

        $datagrid = (new GridConfig())
        ->setComponents([
                (new THead())
                    ->setComponents([
                        (new ColumnHeadersRow()),
                        (new FiltersRow()),
                        (new OneCellRow())
                            ->setRenderSection(RenderableRegistry::SECTION_END)
                            ->setComponents([
                                (new HtmlTag())->setTagName('a')
                                ->setAttributes([
                                    'href' => '/' . \Request::path(),
                                    'class' => 'btn btn-sm btn-success'
                                ])
                                ->addComponent(new RenderFunc(function () {
                                    return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                })),
                                (new HtmlTag())
                                    ->setAttributes(['class' => 'pull-right'])
                                    ->addComponent(new ShowingRecords()),
                            ])
                    ]),( new TFoot()),
            ])
            ->setRowComponent(new GridTr())
            ->setDataProvider(
                new EloquentDataProvider($query)
            )
            ->setName('filter')
            ->setPageSize(10)
            ->setColumns([
                (new FieldConfig('firstname'))->setLabel('Name')
                    ->addFilter((new FilterConfig())
                        ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                            $autorids = [];
                            $autors = ArticleAuthor::get()
                            ->filter(function ($item) use ($val) {
                                return (strpos(strtolower($item->fullName), strtolower($val)) !== false);
                            });
                            foreach ($autors as $autor) {
                                $autorids [] = $autor->id;
                            }
                            $provider->getBuilder()->whereIn('id', $autorids);
                        }))->setSortable(true)
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $author = $row->getSrc();
                        return $author->fullName;
                    }),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        return '<button type"button" class="btn btn-danger form-control delete_button" value="/' . $item->slug . '">Delete</button>';
                    }),
            ]);

        $grid = new Grid($datagrid);
        $grid = $grid->render();

        \Session::put('back_url', $request->fullUrl());

        return view('admin.partials.index_page.index-grid', $this->articleAuthorsRepository->indexElements(compact('grid')));
    }

    /**
     *
     *
     *
     * RESTFUL METHODS
     *
     *
     *
     */

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        if (\Session::get('back_url')) {
            $back_url = \Session::get('back_url');
        } else {
            $back_url = '/author';
        }

        return view($this->articleAuthorsRepository->getAdminFolderPath() . '.create', compact('back_url'));
    }

    /**
     * Store a newly created resource in storage
     *
     * @return Response
     */
    public function store(ArticleAuthorRequest $request)
    {

        $author = ArticleAuthor::create($request->all());

        if (!empty($request->image['source'])) {
            $author->articleAuthorImages()->create($request->image);
        }

        return redirect($request->back_url);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show(ArticleAuthor $author)
    {
		

        $page_items['main_articles']        = $author->articles()->select('articles.*','article_categories.title as cattitle')->leftJoin('article_categories', 'article_categories.id', '=', 'articles.article_category_id')->published()->limit(10)->get();
		
		
        $page_items['author']               = $author;
        $page_items['side_article_content'] = Article::randomArticles();

        return view('site.author_article_list', $page_items);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit(ArticleAuthor $author)
    {
        if (\Session::get('back_url')) {
            $back_url = \Session::get('back_url');
        } else {
            $back_url = '/author';
        }

        return view($this->articleAuthorsRepository->getAdminFolderPath() . '.edit', compact('author', 'back_url'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function update(ArticleAuthor $author, ArticleAuthorRequest $request)
    {

        $author->update($request->all());

        if ($author->articleAuthorImages->isNotEmpty()) {
            $author->articleAuthorImages->first()->update($request->image);
        } else {
            $author->articleAuthorImages()->create($request->image);
        }

        return redirect($request->back_url);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy(ArticleAuthor $author)
    {

        $author->delete();
        $author->articleAuthorImages()->delete();

        return redirect('author');
    }

    /**
     *
     *
     *
     * AJAX
     *
     *
     *
     */

    /**
     * @param Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function moreArticles(Request $request, $author_name)
    {
			
        $limit  = $request->limit;
        $offset = $request->offset;

        $articles = ArticleAuthor::where('slug', 'marex')->first()->articles()->select('articles.*','article_categories.title as cattitle')->leftJoin('article_categories', 'article_categories.id', '=', 'articles.article_category_id')->published()->offset($offset)->limit($limit)->get();

        return view('site.partials.article.more_article_content_new', compact('articles'));
    }
}
