<?php

namespace App\Http\Controllers;

use App\Article;
use App\ArticleCategory;
use App\Repositories\ArticleCategoriesRepository;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\ArticleType;
use Log;

class ArticleCategoriesController extends Controller
{
    private $articleCategoriesRepository;

    public function __construct(ArticleCategoriesRepository $articleCategoriesRepository)
    {

        $this->middleware('auth', ['except' => ['articleList', 'moreArticles']]);
        $this->middleware('subscriber.cookie', ['only' => ['articleList']]);

        $this->articleCategoriesRepository = $articleCategoriesRepository;
    }

    /**
     *
     *
     *
     * CUSTOM ROUTE METHODS
     *
     *
     *
     */

    /**
     * Page shows lists of type article categories
     *
     * @param $category
     */
    public function articleList($category)
    {

        $category = $category . '-news';

        Log::debug('ArticleCategoriesController METHOD: articleList');
        Log::debug($category);

        $page_items['category']             = ArticleCategory::whereSlug($category)->first();
        $page_items['main_articles']        = $page_items['category']->articles()->published()->limit(10)->get();
        $page_items['side_article_content'] = Article::randomArticles();

        return view('site.article_list', $page_items);
    }

    /**
     *
     *
     *
     * RESTFUL METHODS
     *
     *
     *
     */

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(Request $request)
    {

        //if a query exists from Scout get the string
        $query = $request->input('query');

        //check if the query is empty if it isn't use the scout search method before paginating
        $collection = empty($query) ? ArticleCategory::paginate(10) : ArticleCategory::search($query)->paginate(10);

        return view('admin.partials.index_page.index', $this->articleCategoriesRepository->indexElements(compact('collection')));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $article_types = ArticleType::pluck('title', 'id');

        return view($this->articleCategoriesRepository->getAdminFolderPath() . '.create', compact('article_types'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        ArticleCategory::create($request->all());

        return redirect($this->articleCategoriesRepository->getRoutePath());
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(ArticleCategory $category)
    {

        $article_types = ArticleType::pluck('title', 'id');

        return view($this->articleCategoriesRepository->getAdminFolderPath() . '.edit', compact('category', 'article_types'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request '
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ArticleCategory $category)
    {

        $category->update($request->all());

        return redirect($this->articleCategoriesRepository->getRoutePath());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(ArticleCategory $category)
    {

        $category->delete();

        return redirect($this->articleCategoriesRepository->getRoutePath());
    }

    /**
     *
     *
     *
     * AJAX
     *
     *
     *
     */

    /**
     * @param Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function moreArticles(Request $request)
    {

        $limit  = $request->limit;
        $offset = $request->offset;
        $slug   = $request->slug;

        $articles = ArticleCategory::whereSlug($slug)->first()->articles()->published()->offset($offset)->limit($limit)->get();

        return view('site.partials.article.more_articles_content', compact('articles'));
    }
}
