<?php

namespace App\Http\Controllers;
use App\ArticleAuthor;
use App\Article;
use App\ArticleMagazineEdition;
use App\ArticleMagazineMonth;
use App\Repositories\ArticleMagazineEditionsRepository;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ArticleMagazineEditionsController extends Controller
{

    protected $articleMagazineEditionsRepository;

    public function __construct(ArticleMagazineEditionsRepository $articleMagazineEditionsRepository)
    {

        $this->middleware('auth', [
            'except' => [
                'index',
                'edition',
            ],
        ]);
        $this->middleware('subscriber.cookie', [
            'only' => [
                'index',
                'edition',
            ],
        ]);

        $this->articleMagazineEditionsRepository = $articleMagazineEditionsRepository;
    }

    /**
     *
     *
     *
     * CUSTOM ROUTE METHODS
     *
     *
     *
     */

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function admin(Request $request)
    {

        //if a query exists from Scout get the string
        $query = $request->input('query');

        //check if the query is empty if it isn't use the scout search method before paginating
        $collection = empty($query) ? ArticleMagazineEdition::orderBy('year', 'DESC')->orderBy('article_magazine_month_id', 'DESC')->paginate(10) : ArticleMagazineEdition::search($query)->orderBy('year', 'DESC')->orderBy('article_magazine_month_id')->paginate(10);

        return view('admin.partials.index_page.index', $this->articleMagazineEditionsRepository->indexElements(compact('collection')));
    }

    /**
     * @param $year
     * @param $month
     */
    public function edition($magazine_year, $magazine_month)
    {

        $editions        = ArticleMagazineEdition::with('articleMagazineMonth')->where('published_at', '!=', '0000-00-00 00:00:00')->where('published_at', '<=', Carbon::now()->toDateTimeString())->where('year', '>', '2010')->orderBy('year')->orderBy('article_magazine_month_id')->get();
        $current_edition = ArticleMagazineEdition::where([
            [
                'year',
                '=',
                $magazine_year,
            ],
            [
                'article_magazine_month_id',
                '=',
                $magazine_month,
            ],
        ])->first();
        $articles        = $current_edition->articles->load('articleCategory')->keyBy('articleCategory.slug');

        return view('site.magazine', compact('editions', 'current_edition', 'articles'));
    }

    /**
     *
     *
     *
     * RESTFUL METHODS
     *
     *
     *
     */

    public function index()
    {
        $editions = ArticleMagazineEdition::with('articleMagazineMonth')
            ->where('published_at', '!=', '0000-00-00 00:00:00')
            ->where('published_at', '<=', Carbon::now()->toDateTimeString())
            ->where('year', '>', '2010')->orderBy('year')
            ->orderBy('article_magazine_month_id')
            ->get();

        $current_edition = ArticleMagazineEdition::select('article_magazine_editions.*','aa.firstname as eifirstname','aa.lastname as eilastname','article_authors.lastname as lastname','article_authors.firstname as firstname')->with('articles')
            ->where('published_at', '!=', '0000-00-00 00:00:00')
            ->where('published_at', '<=', Carbon::now()->toDateTimeString())->leftJoin('article_authors', 'article_authors.id', '=', 'article_magazine_editions.cs_author')->leftJoin('article_authors as aa', 'aa.id', '=', 'article_magazine_editions.ei_author')
            ->orderBy('id', 'DESC')
            ->first();

        $articles = $current_edition
            ->articles
            ->load('articleCategory')
            ->keyBy('articleCategory.slug');

        /* $top_stories = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->limit(4)
            ->get(); */
			$add_ads = true;
        return view('site.magazine', compact('editions', 'current_edition', 'articles', 'top_stories','add_ads'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $data               = [];
        $data['months']     = ArticleMagazineMonth::pluck('name', 'id');
        $data['start_year'] = Carbon::now()->addYears(1)->year;
        $data['end_year']   = '2007';
		$data['article_authors'] = ArticleAuthor::orderBy('firstname')->get()->pluck('full_name', 'id');
        return view($this->articleMagazineEditionsRepository->getAdminFolderPath() . '.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        ArticleMagazineEdition::create($request->all());

        return redirect('/magazine/edition/admin');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    { }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(ArticleMagazineEdition $edition)
    {

        $data               = [];
        $data['edition']    = $edition;
        $data['months']     = ArticleMagazineMonth::pluck('name', 'id');
        $data['start_year'] = Carbon::now()->addYears(1)->year;
        $data['end_year']   = '2007';
		$data['article_authors'] = ArticleAuthor::orderBy('firstname')->get()->pluck('full_name', 'id');
        return view($this->articleMagazineEditionsRepository->getAdminFolderPath() . '.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ArticleMagazineEdition $edition)
    {

        $edition->update($request->all());

        return redirect('/magazine/edition/admin');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(ArticleMagazineEdition $edition)
    {

        $edition->delete();

        return redirect('/magazine/edition/admin');
    }
}
