<?php

namespace App\Http\Controllers;

use App\Article;
use App\ArticleMagazineMonth;
use App\Repositories\ArticleMagazineMonthsRepository;
use Illuminate\Http\Request;

use Grids;
use Nayjest\Grids\Components\FiltersRow;
use Nayjest\Grids\Components\Footer;
use Nayjest\Grids\Components\Header;
use Nayjest\Grids\Components\Pager;
use Nayjest\Grids\Components\RenderFunc;
use Nayjest\Grids\DataProvider;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\EloquentDataRow;
use Nayjest\Grids\FieldConfig;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\SelectFilterConfig;
use Nayjest\Grids\Grid;
use Nayjest\Grids\GridConfig;
use Nayjest\Grids\IdFieldConfig;
use Nayjest\Grids\ObjectDataRow;
use App\Components\GridTrById;
use Nayjest\Grids\Components\ShowingRecords;
use Nayjest\Grids\Components\TFoot;
use Nayjest\Grids\Components\THead;
use Nayjest\Grids\Components\HtmlTag;
use Nayjest\Grids\Components\ColumnHeadersRow;
use Nayjest\Grids\Components\OneCellRow;
use Nayjest\Grids\Components\Base\RenderableRegistry;

class ArticleMagazineMonthsController extends Controller
{

    protected $articleMagazineMonthsRepository;

    public function __construct(ArticleMagazineMonthsRepository $articleMagazineMonthsRepository)
    {

        $this->middleware('auth');

        $this->articleMagazineMonthsRepository = $articleMagazineMonthsRepository;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(Request $request)
    {
        $query = ArticleMagazineMonth::select('article_magazine_months.*');

        $datagrid = (new GridConfig())
        ->setComponents([
                (new THead())
                    ->setComponents([
                        (new ColumnHeadersRow()),
                        (new FiltersRow()),
                        (new OneCellRow())
                            ->setRenderSection(RenderableRegistry::SECTION_END)
                            ->setComponents([
                                (new HtmlTag())->setTagName('a')
                                ->setAttributes([
                                    'href' => '/' . \Request::path(),
                                    'class' => 'btn btn-sm btn-success'
                                ])
                                ->addComponent(new RenderFunc(function () {
                                    return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                })),
                                (new HtmlTag())
                                    ->setAttributes(['class' => 'pull-right'])
                                    ->addComponent(new ShowingRecords()),
                            ])
                    ]),( new TFoot()),
            ])
            ->setRowComponent(new GridTrById())
            ->setDataProvider(
                new EloquentDataProvider($query)
            )
            ->setName('filter')
            ->setPageSize(10)
            ->setColumns([
                (new FieldConfig('name'))->addFilter((new FilterConfig()))->setSortable(true),
                (new FieldConfig('start_date'))->addFilter((new FilterConfig())),
                (new FieldConfig('end_date'))->addFilter((new FilterConfig())),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        return '<button type"button" class="btn btn-danger form-control delete_button" value="/' . $item->id . '">Delete</button>';
                    }),
            ]);

        $grid = new Grid($datagrid);
        $grid = $grid->render();

        return view('admin.partials.index_page.index-grid', $this->articleMagazineMonthsRepository->indexElements(compact('grid')));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view($this->articleMagazineMonthsRepository->getAdminFolderPath() . '.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        ArticleMagazineMonth::create($request->all());

        return redirect('magazine/month');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(ArticleMagazineMonth $articleMagazineMonth)
    {

        return view($this->articleMagazineMonthsRepository->getAdminFolderPath() . '.edit', compact('articleMagazineMonth'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ArticleMagazineMonth $articleMagazineMonth)
    {

        $articleMagazineMonth->update($request->all());

        return redirect('magazine/month');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(ArticleMagazineMonth $articleMagazineMonth)
    {
        $articleMagazineMonth->delete();

        return redirect('/magazine/month');
    }
}
