<?php

namespace App\Http\Controllers;

use App\Article;

use Grids;
use Nayjest\Grids\Components\FiltersRow;
use Nayjest\Grids\Components\RenderFunc;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FieldConfig;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\Grid;
use Nayjest\Grids\GridConfig;
use Nayjest\Grids\ObjectDataRow;
use App\Components\GridTr;
use Nayjest\Grids\Components\ShowingRecords;
use Nayjest\Grids\Components\TFoot;
use Nayjest\Grids\Components\THead;
use Nayjest\Grids\Components\HtmlTag;
use Nayjest\Grids\Components\ColumnHeadersRow;
use Nayjest\Grids\Components\OneCellRow;
use Nayjest\Grids\Components\Base\RenderableRegistry;
use App\ArticleCategory;
use App\ArticleAuthor;
use App\ArticleMagazineEdition;
use App\ArticleSlugRedirect;
use App\ArticleTitleTag;
use App\ArticleType;
use App\AnaliyticsView;
use App\Http\Requests\ArticleRequest;
use App\Marex\Reports\ArticleReport;
use App\Repositories\ArticlesRepository;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Http\Request;
use Auth;
use Redirect;
use Carbon\Carbon;

class ArticlesController extends Controller
{
    protected $articlesRepository;

    public function __construct(ArticlesRepository $articlesRepository)
    {
        $this->middleware('auth', [
            'except' => [
                'show',
                'top_article',
                'articleItems',
                'show_blog',
                'show_editorials',
                'show_corporate',
                'show_magazine',
                'check_article_redirect',
                'show_oped',
                'show_features',
                'show_podcast',
                'show_preview',
                'show_job',
                'show_job_redirected',
                'remove',
            ],
        ]);
        $this->middleware('subscriber.cookie', ['only' => 'show']);

        $this->articlesRepository = $articlesRepository;
    }
    /**
     *
     *
     *
     * CUSTOM ROUTE METHODS
     *
     *
     *
     */

    public function report($article_slug, ArticleReport $article_report)
    {
        return $article_report->report($article_slug);
    }

    public function check_article_redirect($slug)
    {
        $article_slug_redirect = ArticleSlugRedirect::whereSlug($slug)->first();

        if ($article_slug_redirect) {
            $article = Article::find($article_slug_redirect->article_id);

            $articlelink = '/' . $article->articleType->slug . '/' . $article->slug;

            $views = $article->views;

            $oldanalitics = AnaliyticsView::where('created_at', '<', Carbon::now()->subDays(3))->limit(1000)->get();
            foreach ($oldanalitics as $item) {
                $item->forcedelete();
            }

            if (!Auth::check() && !AnaliyticsView::where('ip', '=', \Request::ip())->where('slug', '=', $articlelink)->where('created_at', '>=', Carbon::now()->subDays(3))->first()) {
                $view = AnaliyticsView::create([
                    'slug' => $articlelink,
                    'count' => 1,
                    'ip' => \Request::ip(),
                ]);

                $article->update([
                    'views' => $views + 1,
                ]);
            }

            $pageviews = $article->views;

            if ($article && ($article->published_at > Carbon::now()->toDateTimeString() || $article->published_at === '0000-00-00 00:00:00')) {
                $preview = true;
            } else {
                $preview = false;
            }

            $page_items['article']              = $article;
            $page_items['pageviews']            = $pageviews;
            $page_items['side_article_content'] = Article::randomArticles();
            $page_items['preview']              = $preview;

            return \Response::view('site.article', $page_items)->header('Cache-Control', 'no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
        } else {
            abort(404);
        }

        // $this->articlesRepository->check_article_redirect($slug);
    }

    //preview
    public function show_preview($slug)
    {
        $article = Article::whereSlug($slug)->first();

        Redirect::to($article->link, 301)->send();
    }

    //corporate
    public function show_corporate($slug)
    {
        return $this->articlesRepository->show_article($slug, 'corporate');
    }

    //job
    public function show_job($slug)
    {
        return $this->articlesRepository->show_article($slug, 'job');
    }

    //job
    public function show_job_redirected($slug)
    {
        Redirect::to('/jobs/' . $slug, 301)->send();
    }

    //features
    public function show_features($slug)
    {
        return $this->articlesRepository->show_article($slug, 'features');
    }

    //editorials
    public function show_editorials($slug)
    {
        return $this->articlesRepository->show_article($slug, 'editorials');
    }

    //magazine
    public function show_magazine($slug)
    {
        return $this->articlesRepository->show_article($slug, 'magazine');
    }

    //blog
    public function show_blog($slug)
    {
        return $this->articlesRepository->show_article($slug, 'blog');
    }

    //blog
    public function show_podcast($slug)
    {
        return $this->articlesRepository->show_article($slug, 'podcast');
    }

    /**
     *
     *
     *
     * RESTFUL METHODS
     *
     *
     *
     */

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(Request $request)
    {
        if (is_array($request->filter) && array_key_exists("sort", $request->filter) && $request->filter['sort']) {
            $query = Article::select('articles.*')
                ->where('published_at', '!=', '0000-00-00 00:00:00')
                ->leftJoin('article_authors', 'article_authors.id', '=', 'articles.article_author_id')
                ->leftJoin('article_types', 'article_types.id', '=', 'articles.article_type_id')
                ->addSelect('article_types.title as type');
        } else {
            $query = Article::select('articles.*')
                ->where('published_at', '!=', '0000-00-00 00:00:00')
                ->orderBy('published_at', 'DESC')
                ->leftJoin('article_authors', 'article_authors.id', '=', 'articles.article_author_id')
                ->leftJoin('article_types', 'article_types.id', '=', 'articles.article_type_id')
                ->addSelect('article_types.title as type');
        }

        $querydraft = Article::select('articles.*')
            ->where('published_at', '=', '0000-00-00 00:00:00')
            ->orderBy('created_at', 'DESC')
            ->leftJoin('article_authors', 'article_authors.id', '=', 'articles.article_author_id')
            ->leftJoin('article_types', 'article_types.id', '=', 'articles.article_type_id')
            ->addSelect('article_types.title as type');

        $datagrid = (new GridConfig())
            ->setComponents([
                (new THead())
                    ->setComponents([
                        (new ColumnHeadersRow()),
                        (new FiltersRow()),
                        (new OneCellRow())
                            ->setRenderSection(RenderableRegistry::SECTION_END)
                            ->setComponents([
                                (new HtmlTag())->setTagName('a')
                                    ->setAttributes([
                                        'href' => '/' . \Request::path(),
                                        'class' => 'btn btn-sm btn-success'
                                    ])
                                    ->addComponent(new RenderFunc(function () {
                                        return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                    })),
                                (new HtmlTag())
                                    ->setAttributes(['class' => 'pull-right'])
                                    ->addComponent(new ShowingRecords()),
                            ])
                    ]), (new TFoot()),
            ])
            ->setRowComponent(new GridTr())
            ->setDataProvider(
                new EloquentDataProvider($query)
            )
            ->setName('filter')
            ->setPageSize(10)
            ->setColumns([
                (new FieldConfig('published_at'))->setLabel('Published Date')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
                (new FieldConfig())->setLabel('Title')->setName('articles.title')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $article = $row->getSrc();
                        return $article->title;
                    }),
                (new FieldConfig('firstname'))->setLabel('Author')
                    ->addFilter((new FilterConfig())
                            ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                                $autorids = [];
                                $autors = ArticleAuthor::get()
                                    ->filter(function ($item) use ($val) {
                                        return (strpos(strtolower($item->fullName), strtolower($val)) !== false);
                                    });
                                foreach ($autors as $autor) {
                                    $autorids[] = $autor->id;
                                }
                                $provider->getBuilder()->whereIn('article_author_id', $autorids);
                            }))->setSortable(true)
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $article = $row->getSrc();
                        if ($article->articleAuthor) {
                            return $article->articleAuthor->fullName;
                        }
                        return '';
                    }),
                (new FieldConfig())->setLabel('Type')->setName('article_types.title')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $article = $row->getSrc();
                        if ($article->articleType) {
                            return $article->articleType->title;
                        }
                        return '';
                    }),
                (new FieldConfig('views'))->addFilter((new FilterConfig()))->setSortable(true),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        if ($item->newsletters->isEmpty()) {
                            $disabled = 'disabled';
                        } else {
                            $disabled = '';
                        }
                        return '<button data-article_slug="' . $item->slug . '" class="btn btn-default btn-block article_report" type="button" ' . $disabled . '>Run Report</button>';
                    }),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        if ($item->top_article == '1') {
                            return '<button class="btn btn-info btn-block top_article" disabled type="button">Current</button>';
                        } else {
                            return '<button class="btn btn-default btn-block top_article" type="button">Top Article</button>';
                        }
                    }),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        return '<a target="_blank" class="btn btn-default btn-block" href="' . $item->link . '">View</a>';
                    }),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        return '<button type"button" class="btn btn-danger form-control delete_button" value="' . $item->slug . '">Delete</button>';
                    }),
            ]);

        $datadraft = (new GridConfig())
            ->setComponents([
                (new THead())
                    ->setComponents([
                        (new ColumnHeadersRow()),
                    ]), (new TFoot()),
            ])
            ->setRowComponent(new GridTr())
            ->setDataProvider(
                new EloquentDataProvider($querydraft)
            )
            ->setName('filterdraft')
            ->setPageSize(10)
            ->setColumns([
                (new FieldConfig('published_at'))->setLabel('Published Date'),
                (new FieldConfig())->setLabel('Title')->setName('articles.title')
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $article = $row->getSrc();
                        return $article->title;
                    }),
                (new FieldConfig('firstname'))->setLabel('Author')
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $article = $row->getSrc();
                        if ($article->articleAuthor) {
                            return $article->articleAuthor->fullName;
                        }
                        return '';
                    }),
                (new FieldConfig())->setLabel('Type')->setName('article_types.title')
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $article = $row->getSrc();
                        if ($article->articleType) {
                            return $article->articleType->title;
                        }
                        return '';
                    }),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        if ($item->newsletters->isEmpty()) {
                            $disabled = 'disabled';
                        } else {
                            $disabled = '';
                        }
                        return '<button data-article_slug="' . $item->slug . '" class="btn btn-default btn-block article_report" type="button" ' . $disabled . '>Run Report</button>';
                    }),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        if ($item->top_article == '1') {
                            return '<button class="btn btn-info btn-block top_article" disabled type="button">Current</button>';
                        } else {
                            return '<button class="btn btn-default btn-block top_article" type="button">Top Article</button>';
                        }
                    }),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        return '<a target="_blank" class="btn btn-default btn-block" href="' . $item->link . '">Preview</a>';
                    }),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        return '<button type"button" class="btn btn-danger form-control delete_button" value="' . $item->slug . '">Delete</button>';
                    }),
            ]);

        $grid = new Grid($datagrid);
        $grid = $grid->render();

        $drafts = new Grid($datadraft);
        $drafts = $drafts->render();

        \Session::put('back_url', $request->fullUrl());

        return view('admin.articles.index', $this->articlesRepository->indexElements(compact('drafts', 'grid')));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        if (\Session::get('back_url')) {
            $back_url = \Session::get('back_url');
        } else {
            $back_url = '/article';
        }

        return view($this->articlesRepository->getAdminFolderPath() . '.create', $this->articlesRepository->formElements(compact('back_url')));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store(ArticleRequest $request)
    {
        $article = Auth::user()->articles()->create($request->all());

        if ($request->short_url) {
            $this->articlesRepository->store_slug_redirect($article, $request->short_url);
        }

        $this->articlesRepository->syncItems($article, $request);

        //Redirect to the admin article home page
        return redirect($request->back_url);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show(Article $article)
    {
        $articlelink = '/' . $article->articleType->slug . '/' . $article->slug;

        $views = $article->views;

        $oldanalitics = AnaliyticsView::where('created_at', '<', Carbon::now()->subDays(3))->limit(1000)->get();
        foreach ($oldanalitics as $item) {
            $item->forcedelete();
        }

        if (!Auth::check() && !AnaliyticsView::where('ip', '=', \Request::ip())->where('slug', '=', $articlelink)->where('created_at', '>=', Carbon::now()->subDays(3))->first()) {
            $view = AnaliyticsView::create([
                'slug' => $articlelink,
                'count' => 1,
                'ip' => \Request::ip(),
            ]);

            $article->update([
                'views' => $views + 1,
            ]);
        }

        $pageviews = $article->views;

        if ($article && ($article->published_at > Carbon::now()->toDateTimeString() || $article->published_at === '0000-00-00 00:00:00')) {
            $preview = true;
        } else {
            $preview = false;
        }
		$article->content = str_replace('/media/images/','https://maritime-executive.com//media/images/',$article->content);
        $page_items['article']              = $article;
        $page_items['pageviews']            = $pageviews;
        $page_items['side_article_content'] = Article::randomArticles();
        $page_items['preview']              = $preview;
        $page_items['top_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->limit(4)
            ->get();
        $page_items['more_top_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->skip(4)
            ->limit(4)
            ->get();

        /* @todo */
        $page_items['related_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->limit(4)
            ->get();
		$categories = ArticleCategory::whereIn('id', ['6', '5', '3'])
            ->limit(8)
			->orderBy('order', 'asc') 
            ->get();
		
        foreach ($categories as $key=>$category) {
            $articles = $category->articles()->published()->limit(5)->get();
			
            $categories[$key]['top_article'] = $articles->shift();
            $categories[$key]['articles'] = $articles;
        }
		$page_items['categoriesupper'] = $categories;
        $page_items['editorials'] = Article::published()
            ->where('top_article', '!=', '1')
            ->where('article_type_id', ArticleType::EDITORIAL)
            ->limit(5)
            ->get();

        return \Response::view('site.article', $page_items)
            ->header('Cache-Control', 'no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit(Article $article)
    {
        if (\Session::get('back_url')) {
            $back_url = \Session::get('back_url');
        } else {
            $back_url = '/article';
        }

        $articlelink = '/' . $article->articleType->slug . '/' . $article->slug;
        $pageviews = 0;

        return view($this->articlesRepository->getAdminFolderPath() . '.edit', $this->articlesRepository->formElements(compact('article', 'pageviews', 'back_url')));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function update(Article $article, ArticleRequest $request)
    {
        $request_data = $request->all();

        if (empty($request->published_at) || $request->published_at === '0000-00-00 00:00:00') {
            $request_data['slug'] = SlugService::createSlug(Article::class, 'slug', $request->title);
        }

        //update the article table
        $article->update($request_data);

        $this->articlesRepository->syncItems($article, $request);

        //Redirect to the admin article home page
        return redirect($request->back_url);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy(Article $article)
    {
        $article->delete();

        if (method_exists($article, 'images')) {
            $article->images()->delete();
        }

        return redirect('article');
    }

    /**
     *
     *
     *
     *
     * AJAX METHODS
     *
     *
     *
     *
     */

    /**
     * finds the sub type elements in items.blade.php that are relevant to the provided type and returns them to the
     * ajax request to be inserted into the article sub type div container
     *
     * @param ArticleRequest $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function articleItems(Request $request)
    {
        $article_id      = $request->article_id;
        $article_type_id = $request->article_type_id;

        //check if the article type id is empty and cancel the process if it is
        if (empty($article_type_id)) {
            return null;
        }

        //get the article type name used to decide which subtype elements to view
        $article_type = ArticleType::find($article_type_id);

        //setup the content needed by the sub type view
        if (!empty($article_id)) {
            $this->view_data['article'] = Article::find($article_id);
        }

        $this->view_data['article_type']       = $article_type;
        // $this->view_data['article_categories'] = ArticleCategory::where('article_type_id', $article_type_id)->pluck('title', 'id');
        $this->view_data['article_title_tags'] = ArticleTitleTag::pluck('name', 'id');
        if ($article_type->slug == 'magazine') { //  ->select('article_magazine_editions.*')
            $this->view_data['magazine_editions'] = ArticleMagazineEdition::join('article_magazine_months', 'article_magazine_editions.article_magazine_month_id', '=', 'article_magazine_months.id')
                ->orderBy('article_magazine_editions.year', 'desc')->orderBy('article_magazine_months.order', 'asc')->select('article_magazine_editions.*')->get()->pluck('full_edition_date', 'id');
        }

        //returns the sub type view that has if statements to decide which content to show for a specific type
        return view('admin.articles.partials.items', $this->view_data);
    }

    /**
     * sets the top article for the website
     */
    public function top_article(Request $request)
    {
        //find the articles that have a 1 for top article and set them to 0
        Article::where('top_article', '1')->update([
            'top_article' => '0',
        ]);

        //update the top article position with the article id from the request
        Article::whereId($request->article_id)->update(['top_article' => '1']);
    }

    /**
     * Button on the article form that changes the slug to the currently entered title
     *
     * @param Request $request
     */
    public function update_slug(Request $request)
    {
        $title    = $request->title ?? ''; //current title used to create new slug
        $old_slug = $request->slug ?? ''; //original slug from article
        $new_slug = SlugService::createSlug(Article::class, 'slug', $title); //create new slug from title on the Article Model
        $article  = Article::whereSlug($old_slug)->firstOrFail(); //get the article using the original slug

        //save the old slug to the article_slug_redirects table
        $article->articleSlugRedirect()->create([
            'slug' => $old_slug,
        ]);

        //update the slug
        $article->update([
            'slug' => $new_slug,
        ]);

        return $new_slug;
    }

    public function create_short_url(Request $request)
    {
        $short_slug   = $request->short_slug ?? '';
        $article_slug = $request->article_slug ?? '';

        if (!empty($short_slug) && !empty($article_slug)) {
            $article  = Article::whereSlug($article_slug)->first();
            $response = $this->articlesRepository->store_slug_redirect($article, $short_slug);

            return $response;
        }

        return 'false';
    }

    public function articleImage(Request $request)
    {
        //get the article id from the request
        $article_id = $request->article_id;

        //get the article Image model based on article id
        $article_image = Article::findOrFail($article_id)->article_image;

        //return the article image model
        return $article_image;
    }
}
