<?php

namespace App\Http\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Imagick;
use Log;
use Zip;
use File;
use Response;

class BannerResizingController extends Controller
{
    public function index()
    {

        return view('admin.banner_resize.index');
    }

    public function create(Request $request)
    {
        $rules = [
            'file' => 'image',
        ];

        $validation = Validator::make($request->all(), $rules);

        if ($validation->fails()) {
            return Response::make($validation->errors()->first(), 400);
        }

        Storage::deleteDirectory('public/gif_resize');

        $uploaded_file_path         = $request->file('file')->store('gif_resize', 'public');
        $uploaded_file_original_ext = $request->file('file')->getClientOriginalExtension();

        $image_array = [
            '990x90'  => [
                '301',
                '316',
                '353',
                '368',
                '376',
                '404',
                '466',
                '516',
                '579',
                '750',
                '781',
                '990',
            ],
            '728x90'  => [
                '301',
                '316',
                '353',
                '368',
                '376',
                '404',
                '466',
                '516',
                '579',
                '728',
            ],
            '675x50'  => [
                '675',
                '600',
                '550',
                '500',
                '400',
                '300',
            ],
            '300x250' => [
                '300',
                '277',
                '246',
            ],
        ];

        //delete all files in folder resize except latest file
        File::delete(public_path('gif_resize/resize.zip'));

        //start fresh zip file
        $zip = Zip::create(public_path('gif_resize/resize.zip'));

        foreach ($image_array[$_POST['image_size']] as $width) {
            $imagick = new Imagick('/' . storage_path('app/public/') . $uploaded_file_path);
            $imagick = $imagick->coalesceImages();

            do {
                $imagick->resizeImage($width, 0, Imagick::FILTER_CATROM, .8);
            } while ($imagick->nextImage());

            $imagick    = $imagick->deconstructImages();
            $d          = $imagick->getImageGeometry();
            $image_file = $d['width'] . 'x' . $d['height'] . '.' . $uploaded_file_original_ext;
            $imagick->writeImages(storage_path('app/public/') . explode('.' . $uploaded_file_original_ext, $uploaded_file_path)[0] . $image_file, true);
            $imagick->clear();
            $imagick->destroy();
        }

        foreach (Storage::files('public/gif_resize') as $filename) {
            $file_content = Storage::get($filename);
            Storage::disk('google_dfp')->put(explode('public/gif_resize/', $filename)[1], $file_content);
            try {
                $zip->add(storage_path('app/' . $filename));
            } catch (Exception $e) {
                Log::error($e);
            }
        }

        try {
            $zip->close();
        } catch (Exception $e) {
            Log::error($e);
        }

        echo asset('gif_resize/resize.zip');
    }
}
