<?php

namespace App\Http\Controllers;

use App\ArticleCategory;
use App\ArticleType;
use App\Article;
use Carbon\Carbon;
use Illuminate\Http\Request;

class BlogsController extends Controller
{
    public function __construct()
    {

        $this->middleware('subscriber.cookie', [
            'only' => [
                'index',
                'articleList',
                'moreArticles',
            ],
        ]);
    }

    public function index()
    {

        $blog_articles = ArticleType::whereSlug('blog')->first()->articles()->published()->limit(10)->get();
        $blog_path     = 'blog';
        $blog_slug     = 'blog';

       /*  $top_stories = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->limit(4)
            ->get(); */

        return view('site.blog', compact('blog_articles', 'blog_path', 'blog_slug', 'top_stories'));
    }

    public function articleList($category)
    {

        $category = 'blog-' . $category;

        $blog_articles = ArticleCategory::whereSlug($category)->first()->articles()->published()->limit(10)->get();
        $blog_path     = $blog_articles->first()->articleCategory->slug;
        $blog_slug     = $blog_path;

        return view('site.blog', compact('blog_articles', 'blog_path', 'blog_slug'));
    }

    /**
     *
     *
     *
     * AJAX
     *
     *
     *
     */
}
