<?php

namespace App\Http\Controllers;

use App\Mail\Contact;
use App\Repositories\MailWizzRepository;
use App\Repositories\NewslettersRepository;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Log;
use Request;

class ContactController extends Controller
{
    public function __construct()
    {

        $this->middleware('subscriber.cookie', ['only' => ['index']]);
    }

    private $message_type = [
        'Sales'                         => 'bkeil@maritime-executive.com',
        'Editorial - Online/Newsletter' => ['tonymunoz@maritime-executive.com', 'pbenecki@maritime-executive.com', 'wlaursen@maritime-executive.com'],
        'Editorial - Magazine'          => 'tonymunoz@maritime-executive.com',
        'Circulation'                   => 'blennon@maritime-executive.com',
        'Jobs'                          => 'blennon@maritime-executive.com',
        'Technical Support'             => 'moltmans@maritime-executive.com',
    ];

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {

        return view('site.contact');
    }

    /**
     * @param Request $request
     */
    public function sendEmail(\Illuminate\Http\Request $request)
    {

        Log::info('Send Email for contact form.');

        $secret = '6LeqpUQUAAAAAJrIUfasX3_NgFk5bV0du62Qoavt';

        $ch = curl_init();

        curl_setopt_array($ch, [
            CURLOPT_URL            => 'https://www.google.com/recaptcha/api/siteverify',
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => [
                'secret'   => $secret,
                'response' => Request::input('g-recaptcha-response'),
                'remoteip' => $_SERVER['REMOTE_ADDR'],
            ],
            CURLOPT_RETURNTRANSFER => true,
        ]);

        $output = curl_exec($ch);
        curl_close($ch);

        $response = json_decode($output);

        Log::debug($response);

        $this->validate($request, [
            'email' => 'required|email',
            'firstname' => 'required',
            'comment' => 'required',
        ], [
            'firstname.required' => 'The First Name field is required.',
            'comment.required' => 'The "How can we assist you?" field is required.',
        ]);

        /**
         * start setting up email for send-out if gcaptcha is successful
         */
        if (isset($response->success) && $response->success) {
            //todo-hammy v2 see about adding in automatic translation through google api
            $content         = Request::all();
            $content['logo'] = Request::root() . '/media/images/site/logo/marex_logo.png';


            Mail::to($this->message_type[$content['type']])->send(new Contact($content));
        }

        return view('site.contact_thankyou');
    }
}
