<?php

namespace App\Http\Controllers;

use App\Article;
use App\Directory;
use App\Http\Requests\DirectoryRequest;
use App\Repositories\DirectoriesRepository;
use Illuminate\Http\Request;

use Grids;
use Nayjest\Grids\Components\FiltersRow;
use Nayjest\Grids\Components\Footer;
use Nayjest\Grids\Components\Header;
use Nayjest\Grids\Components\Pager;
use Nayjest\Grids\Components\RenderFunc;
use Nayjest\Grids\DataProvider;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\EloquentDataRow;
use Nayjest\Grids\FieldConfig;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\SelectFilterConfig;
use Nayjest\Grids\Grid;
use Nayjest\Grids\GridConfig;
use Nayjest\Grids\IdFieldConfig;
use Nayjest\Grids\ObjectDataRow;
use App\Components\GridTr;
use Nayjest\Grids\Components\ShowingRecords;
use Nayjest\Grids\Components\TFoot;
use Nayjest\Grids\Components\THead;
use Nayjest\Grids\Components\HtmlTag;
use Nayjest\Grids\Components\ColumnHeadersRow;
use Nayjest\Grids\Components\OneCellRow;
use Nayjest\Grids\Components\Base\RenderableRegistry;

class DirectoriesController extends Controller
{
    private $directoriesRepository;

    public function __construct(DirectoriesRepository $directoriesRepository)
    {

        $this->middleware('auth', ['except' => ['index', 'show', 'directorySearch']]);
        $this->middleware('subscriber.cookie', ['only' => ['index', 'show']]);

        $this->directoriesRepository = $directoriesRepository;
    }

    /**
     *
     *
     *
     * CUSTOM ROUTE METHODS
     *
     *
     *
     */

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function admin(Request $request)
    {

        //if a query exists from Scout get the string
        // $query = $request->input('query');
        //
        // //check if the query is empty if it isn't use the scout search method before paginating
        // $collection = empty($query) ? Directory::paginate(10) : Directory::search($query)->paginate(10);
        //
        // return view('admin.partials.index_page.index', $this->directoriesRepository->indexElements(compact('collection')));
        if (is_array($request->filter) && array_key_exists("sort", $request->filter) && $request->filter['sort']) {
            $query = Directory::select('directories.*');
        } else {
            $query = Directory::select('directories.*')
                ->orderBy('id', 'DESC');
        }

        $datagrid = (new GridConfig())
        ->setComponents([
                (new THead())
                    ->setComponents([
                        (new ColumnHeadersRow()),
                        (new FiltersRow()),
                        (new OneCellRow())
                            ->setRenderSection(RenderableRegistry::SECTION_END)
                            ->setComponents([
                                (new HtmlTag())->setTagName('a')
                                ->setAttributes([
                                    'href' => '/' . \Request::path(),
                                    'class' => 'btn btn-sm btn-success'
                                ])
                                ->addComponent(new RenderFunc(function () {
                                    return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                })),
                                (new HtmlTag())
                                    ->setAttributes(['class' => 'pull-right'])
                                    ->addComponent(new ShowingRecords()),
                            ])
                    ]),( new TFoot()),
            ])
            ->setRowComponent(new GridTr())
            ->setDataProvider(
                new EloquentDataProvider($query)
            )
            ->setName('filter')
            ->setPageSize(10)
            ->setColumns([
                (new FieldConfig('company'))->setLabel('Company')
                    ->addFilter((new FilterConfig())
                        ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                            $directoriids = [];
                            $directoris = Directory::get()
                            ->filter(function ($item) use ($val) {
                                return (strpos(strtolower($item->company), strtolower($val)) !== false);
                            });
                            foreach ($directoris as $directori) {
                                $directoriids [] = $directori->id;
                            }
                            $provider->getBuilder()->whereIn('id', $directoriids);
                        }))->setSortable(true)
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $directori = $row->getSrc();
                        return $directori->company;
                    }),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        return '<button type"button" class="btn btn-danger form-control delete_button" value="' . $item->slug . '">Delete</button>';
                    }),
            ]);

        $grid = new Grid($datagrid);
        $grid = $grid->render();

        \Session::put('back_url', $request->fullUrl());

        return view('admin.partials.index_page.index-grid', $this->directoriesRepository->indexElements(compact('grid')));
    }

    /**
     *
     *
     *
     * RESTFUL METHODS
     *
     *
     *
     */

    public function index()
    {

        $directory_list       = Directory::limit(10)->orderBy('company')->get();
        $side_article_content = Article::randomArticles();

       /*  $top_stories = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->limit(4)
            ->get(); */

        return view('site.directory', compact('directory_list', 'side_article_content', 'top_stories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view($this->directoriesRepository->getAdminFolderPath() . '.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(DirectoryRequest $request)
    {
        $this->validate($request, [
            // 'street' => 'required',
            // 'city' => 'required',
            // 'region' => 'required',
            // 'postal_code' => 'required',
            // 'country' => 'required',
            'company' => 'required',
            'phone' => 'required',
            'website' => 'required',
            'description' => 'required',
            'logo' => 'required',
        ]);

        Directory::create($request->all());

        return redirect('directory/admin');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Directory $directory)
    {

        return view('site.directory_listing', compact('directory'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Directory $directory)
    {

        return view($this->directoriesRepository->getAdminFolderPath() . '.edit', compact('directory'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(DirectoryRequest $request, Directory $directory)
    {
        $this->validate($request, [
            // 'street' => 'required',
            // 'city' => 'required',
            // 'region' => 'required',
            // 'postal_code' => 'required',
            // 'country' => 'required',
            'company' => 'required',
            'phone' => 'required',
            'website' => 'required',
            'description' => 'required',
            'logo' => 'required',
        ]);

        $directory->update($request->all());

        return redirect('directory/admin');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Directory $directory)
    {

        $directory->delete();

        return redirect('directory/admin');
    }

    /**
     *
     *
     *
     *
     *
     * AJAX
     *
     *
     *
     *
     *
     */

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function directorySearch(Request $request)
    {

        $alpha = $request->alpha;
        $value = $request->value;

        $directory_list = $alpha ? Directory::where('company', 'LIKE', $value . '%')->orderBy('company')->get() : Directory::search($value)->orderBy('company')->get();

        return view('site.partials.directory.directory_list', compact('directory_list'));
    }
}
