<?php

namespace App\Http\Controllers;

use App\Event;
use App\Http\Requests\EventRequest;
use App\Repositories\EventsRepository;
use Carbon\Carbon;
use Illuminate\Http\Request;

class EventsController extends Controller
{

    protected $eventsRepository;

    public function __construct(EventsRepository $eventsRepository)
    {

//        $this->middleware('auth');

        $this->eventsRepository = $eventsRepository;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(Request $request)
    {

        //if a query exists from Scout get the string
        $query = $request->input('query');

        //check if the query is empty if it isn't use the scout search method before paginating
        $collection = empty($query) ? Event::paginate(10) : Event::search($query)->paginate(10);

        return view('admin.partials.index_page.index', $this->eventsRepository->indexElements(compact('collection')));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view($this->eventsRepository->getAdminFolderPath() . '.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(EventRequest $request)
    {

        Event::create($request->all());

        return redirect('event');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Event $event)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Event $event)
    {

        return view($this->eventsRepository->getAdminFolderPath() . '.edit', compact('event'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(EventRequest $request, Event $event)
    {

        $event->update($request->all());

        return redirect('event');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Event $event)
    {

        $event->delete();

        return redirect('event');
    }

    /**
     *
     *
     *
     *
     *
     * AJAX
     *
     *
     *
     *
     *
     */

    public function events_by_month($event_year, $event_month)
    {

        $current_date = Carbon::create($event_year, $event_month, 1);

        // $events =  Event::where([
        //     ['ended_at', '<=', $current_date->endOfMonth()->toDateString()],
        //     ['started_at', '>=', $current_date->startOfMonth()->toDateString()],
        // ])->get();

        $events = Event::whereIn(\DB::raw('MONTH(started_at)'), [$event_month])
                        ->whereIn(\DB::raw('YEAR(started_at)'), [$event_year])->get();

        return view('site.partials.event.home_page_event_block', compact('events'));
    }
	
	public function events_by_monthnew($event_year, $event_month)
    {

        $current_date = Carbon::create($event_year, $event_month, 1);

        // $events =  Event::where([
        //     ['ended_at', '<=', $current_date->endOfMonth()->toDateString()],
        //     ['started_at', '>=', $current_date->startOfMonth()->toDateString()],
        // ])->get();

        $events = Event::whereIn(\DB::raw('MONTH(started_at)'), [$event_month])
                        ->whereIn(\DB::raw('YEAR(started_at)'), [$event_year])->get();

        return view('site.partials.event.homepage_event', compact('events'));
    }
	
	public function events_by_monthnew_new($event_year, $event_month)
    {

        $current_date = Carbon::create($event_year, $event_month, 1);

        // $events =  Event::where([
        //     ['ended_at', '<=', $current_date->endOfMonth()->toDateString()],
        //     ['started_at', '>=', $current_date->startOfMonth()->toDateString()],
        // ])->get();

        $events = Event::whereIn(\DB::raw('MONTH(started_at)'), [$event_month])
                        ->whereIn(\DB::raw('YEAR(started_at)'), [$event_year])->orderBy('started_at','asc')->get();
		$months       = collect();
		 $current_date = Carbon::today();
		$months->push($current_date);
		for ($x = 1; $x < 12; $x++) {
            $current_date = Carbon::today();
            $current_date->addMonthNoOverflow($x);

            $months->push($current_date);
        }
        return view('site.events', compact('events', 'months'));
    }
	
	 public function events()
    {
        $current_date = Carbon::today();
        $months       = collect();
        $events       = Event::where([
            [
                'ended_at',
                '<=',
                $current_date->endOfMonth()->toDateString(),
            ],
            [
                'started_at',
                '>=',
                $current_date->startOfMonth()->toDateString(),
            ],
        ])->orderBy('started_at','asc')->get();

        $months->push($current_date);

        for ($x = 1; $x < 12; $x++) {
            $current_date = Carbon::today();
            $current_date->addMonthNoOverflow($x);

            $months->push($current_date);
        }

       /*  return [
            "months" => $months,
            "events" => $events,
        ]; */
        return view('site.events', compact('events', 'months'));
    }
}
