<?php

namespace App\Http\Controllers;

use App\Article;
use App\ArticleAuthor;
use Request;
use DB;
class FeaturesController extends Controller
{

    /**
     * FeaturesController constructor.
     */
    public function __construct()
    {
        $this->middleware('subscriber.cookie', ['only' => ['index']]);
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {

        $authors = ArticleAuthor::whereHas('articles', function ($query) {
            $query->whereIn('article_type_id', [3, 4]);
        })->orderBy(DB::raw("if(firstname = '' or firstname is null,1,0),firstname "))->get()->pluck('full_name', 'id');

        $articles = Article::published()
			->select('articles.*','article_categories.title as cattitle')->leftJoin('article_categories', 'article_categories.id', '=', 'articles.article_category_id')
            ->whereIn('articles.article_type_id', [3, 4])
            ->with('articleCategory')
            ->whereNotIn('articles.article_category_id',[0])
            ->limit(10)
            ->get();

        $main_article = $articles->shift();

        $secondary_stories = $articles->take(6);
		
		
        $tertiary_stories = $articles->slice(6, 3)->all();

        return view('site.feature', compact(
            'main_article',
            'secondary_stories',
            'tertiary_stories',
            'articles',
            'authors'
        ));
    }

    /**
     *
     *
     *
     * AJAX
     *
     *
     *
     */

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function search()
    {
        $feature_check   = Request::input('features');
        $editorial_check = Request::input('editorials');
        $author_id       = Request::input('author_id');
        $limit           = empty(Request::input('limit')) ? 9 : Request::input('limit');
        $offset          = empty(Request::input('offset')) ? 0 : Request::input('offset');

        $types = ['editorials' => 4, 'features' => 3];

        if (empty($feature_check) || empty($editorial_check)) {
            unset($types[$feature_check]);
            unset($types[$editorial_check]);
        }

        $articles = Article::published()
			->select('articles.*','article_categories.title as cattitle')->leftJoin('article_categories', 'article_categories.id', '=', 'articles.article_category_id')
            ->whereIn('articles.article_type_id', $types);

        if (!empty($author_id)) {
            $articles = $articles->where('article_author_id', $author_id);
        }
		$articles = $articles->limit($limit)->offset($offset)->orderBy('id','desc')->get();
        /* $articles = $articles
            ->limit(25)->orderBy('id','desc')
            ->get(); */

        $secondary_stories = $articles->take(6);
        $tertiary_stories = $articles->slice(6, 19)->all();

        return view('site.partials.features.feature_content_box', [
            'secondary_stories' => $secondary_stories,
            'tertiary_stories' => $tertiary_stories,
        ]);
    }
}
