<?php

namespace App\Http\Controllers;

use App\Article;
use App\ArticleType;
use App\Event;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\ArticleCategory;

class HomeController extends Controller
{
    private $page_items;

    public function __construct()
    {
        $this->middleware('subscriber.cookie', ['only' => ['index']]);
    }

    public function index()
    {
         $months       = collect();
		$this->page_items['top_article'] = Article::topArticle();
        $this->page_items['top_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->limit(4)
            ->get();
			$articleids	=	array();
			 foreach($this->page_items['top_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        $this->page_items['more_top_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->skip(4)
            ->limit(4)
            ->get();
		foreach($this->page_items['more_top_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
		
		$this->page_items['last3days'] = Article::where('published_at', '!=', '0000-00-00 00:00:00')
			->where('published_at', '<=', Carbon::now())
            ->whereNotIn('id', $articleids)
            ->whereDate('created_at', '>=', Carbon::now()->subDays(6)) 
            ->orderBy('views', 'DESC')
            ->limit(4)
            ->get();
		
        /* Lets get the trending stories based on the number of views per week */
        $this->page_items['trending_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->orderBy('views_week', 'DESC')
            ->limit(3)
            ->get();
		
		foreach($this->page_items['trending_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
		
         $this->page_items['featured_stories'] = Article::published()
            ->where('article_type_id', '=', '3')
			->orderBy('views_week', 'DESC')
            ->limit(3)
            ->get();

		foreach($this->page_items['featured_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
		
        $this->page_items['blogs'] = Article::published()
            ->where('top_article', '!=', '1')
            ->where('article_type_id', ArticleType::BLOG)
            ->orderBy('views_week', 'DESC')
            ->limit(3)
            ->get();

		foreach($this->page_items['blogs'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        $this->page_items['podcast'] = Article::published()
            ->where('top_article', '!=', '1')
            ->where('article_type_id', ArticleType::PODCAST)
            ->orderBy('views_week', 'DESC')
            ->limit(3)
            ->get();

		foreach($this->page_items['podcast'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        $this->page_items['editorials'] = Article::published()
            ->where('top_article', '!=', '1')
            ->where('article_type_id', ArticleType::EDITORIAL)
            ->orderBy('views_week', 'DESC')
            ->limit(3)
            ->get();
			
		foreach($this->page_items['editorials'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        /* Secondary top stories */
        $this->page_items['secondary_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereIn('article_type_id', ['1', '7', '9'])
            ->with('articleCategory')
            ->skip(4)
            ->limit(6)
            ->get();
		foreach($this->page_items['secondary_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        /* Tertiary top stories */
        $this->page_items['tertiary_stories1'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->skip(4)
            ->limit(4)
            ->get();

        
        $this->page_items['side_article_content'] = Article::randomArticles();
		foreach($this->page_items['side_article_content'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        /* Load up the categories and top articles for each category */
        $categories = ArticleCategory::whereIn('id', ['4', '2', '11','8'])
            ->limit(8)
			->orderBy('order', 'asc') 
            ->get();
		
        foreach ($categories as $key=>$category) {
            $articles = $category->articles()->published()->limit(5)->get();
			
            $categories[$key]['top_article'] = $articles->shift();
            $categories[$key]['articles'] = $articles;
        }
        $this->page_items['category_summaries'] = $categories;
		
		
        $categoriesupper = ArticleCategory::whereIn('id', ['1', '7', '9'])
            ->limit(8)
            ->get();

        foreach ($categoriesupper as $key=>$category) {
            $articles = $category->articles()->published()->limit(5)->get();
			 
            $categoriesupper[$key]['top_article'] = $articles->shift();
            $categoriesupper[$key]['articles'] = $articles;
        }
        $this->page_items['categoriesupper'] = $categoriesupper;
		
        $categoriesports = ArticleCategory::whereIn('id', ['6', '5', '3'])
            ->limit(8)
            ->get();

        foreach ($categoriesports as $key=>$category) {
            $articles = $category->articles()->published()->limit(5)->get();
			 
            $categoriesports[$key]['top_article'] = $articles->shift();
            $categoriesports[$key]['articles'] = $articles;
        }
        $this->page_items['categoriesports'] = $categoriesports;
		
		
		$this->page_items['articleids'] = $articleids;
        $this->page_items['eventsData'] = $this->events();

        return view('site.home', $this->page_items);
    } 


	public function duplicate()
    {
        $months       = collect();
		$this->page_items['top_article'] = Article::topArticle();
        $this->page_items['top_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->limit(4)
            ->get();
			$articleids	=	array();
			 foreach($this->page_items['top_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        $this->page_items['more_top_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->skip(4)
            ->limit(4)
            ->get();
		foreach($this->page_items['more_top_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
		
		$this->page_items['last3days'] = Article::where('published_at', '!=', '0000-00-00 00:00:00')
			->where('published_at', '<=', Carbon::now())
            ->whereNotIn('id', $articleids)
            ->whereDate('created_at', '>=', Carbon::now()->subDays(6)) 
            ->orderBy('views', 'DESC')
            ->limit(4)
            ->get();
		
        /* Lets get the trending stories based on the number of views per week */
        $this->page_items['trending_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->orderBy('views_week', 'DESC')
            ->limit(3)
            ->get();
		
		foreach($this->page_items['trending_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
		
         $this->page_items['featured_stories'] = Article::published()
            ->where('article_type_id', '=', '3')
			->orderBy('views_week', 'DESC')
            ->limit(3)
            ->get();

		foreach($this->page_items['featured_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
		
        $this->page_items['blogs'] = Article::published()
            ->where('top_article', '!=', '1')
            ->where('article_type_id', ArticleType::BLOG)
            ->orderBy('views_week', 'DESC')
            ->limit(3)
            ->get();

		foreach($this->page_items['blogs'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        $this->page_items['editorials'] = Article::published()
            ->where('top_article', '!=', '1')
            ->where('article_type_id', ArticleType::EDITORIAL)
            ->orderBy('views_week', 'DESC')
            ->limit(3)
            ->get();
			
		foreach($this->page_items['editorials'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        /* Secondary top stories */
        $this->page_items['secondary_stories'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereIn('article_type_id', ['1', '7', '9'])
            ->with('articleCategory')
            ->skip(4)
            ->limit(6)
            ->get();
		foreach($this->page_items['secondary_stories'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        /* Tertiary top stories */
        $this->page_items['tertiary_stories1'] = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->skip(4)
            ->limit(4)
            ->get();

        
        $this->page_items['side_article_content'] = Article::randomArticles();
		foreach($this->page_items['side_article_content'] as $key => $article)
			 {
				 $articleids[] = $article->id;
			 }
        /* Load up the categories and top articles for each category */
        $categories = ArticleCategory::whereIn('id', ['4', '2', '11','8'])
            ->limit(8)
			->orderBy('order', 'asc') 
            ->get();
		
        foreach ($categories as $key=>$category) {
            $articles = $category->articles()->published()->limit(5)->get();
			
            $categories[$key]['top_article'] = $articles->shift();
            $categories[$key]['articles'] = $articles;
        }
        $this->page_items['category_summaries'] = $categories;
		
		
        $categoriesupper = ArticleCategory::whereIn('id', ['1', '7', '9'])
            ->limit(8)
            ->get();

        foreach ($categoriesupper as $key=>$category) {
            $articles = $category->articles()->published()->limit(5)->get();
			 
            $categoriesupper[$key]['top_article'] = $articles->shift();
            $categoriesupper[$key]['articles'] = $articles;
        }
        $this->page_items['categoriesupper'] = $categoriesupper;
		
        $categoriesports = ArticleCategory::whereIn('id', ['6', '5', '3'])
            ->limit(8)
            ->get();

        foreach ($categoriesports as $key=>$category) {
            $articles = $category->articles()->published()->limit(5)->get();
			 
            $categoriesports[$key]['top_article'] = $articles->shift();
            $categoriesports[$key]['articles'] = $articles;
        }
        $this->page_items['categoriesports'] = $categoriesports;
		
		
		$this->page_items['articleids'] = $articleids;
        $this->page_items['eventsData'] = $this->events();
		$this->page_items['searchnew'] = true;

        return view('site.duplicate', $this->page_items);
    }
	
	function loaddataajax()
	{
		
		 $ids		=	 base64_decode($_POST['ids']);
		  $articleids = unserialize($ids); 
		
			 $this->page_items['last7days'] = Article::where('published_at', '!=', '0000-00-00 00:00:00')
			->where('published_at', '<=', Carbon::now())
            ->whereNotIn('id', $articleids)
            ->whereDate('created_at', '>=', Carbon::now()->subDays(7)) 
            ->orderBy('views', 'DESC')
            ->paginate(6);
			$html = '';
			if(isset($this->page_items['last7days'])){
    foreach($this->page_items['last7days'] as $key => $article){
    $html .= '<article class="article col-lg-4 col-md-4 col-sm-4 col-xs-12">
        <div class="data-wrapper">
            <div class="blog-item">
               <div class="image no-padding-xs">';
			
			if(isset($article->article_image) && is_object($article->article_image) && $article->article_image->source){
    $html .= '<img src="https://maritime-executive.com'.($article->article_image->source ?: '').'" alt="'.(isset($article->article_image->alternate_text) ? $article->article_image->alternate_text : '').'" class="img-responsive"  />';
			}elseif(isset($source)){
   $html .= '';
			}
			
			$html .= '</div>
                <div class="desc body no-padding-xs">
			<h2 class="title">
                        <a href="'.$article->link.'" target="_blank" class="font-firasans">'.$article->title.'</a>
                    </h2>';

                   if($article->articleAuthor)
   $html .= ' <p class="author">
        By
        <b>
            <a href="'.$article->articleAuthor->link.'" class="color-2 font-roboto">
                '.$article->articleAuthor->firstname . ' ' . $article->articleAuthor->lastname.'
            </a>
        </b>'.date("m-d-Y h:i:s",strtotime($article->published_at)).'
                       ';
            
       
     $html .= '</p>';


                     $html .= '<p class="summary">
                        '.$article->content_summary.'
                    </p>

                    <a href="'.$article->link.'" target="_blank" class="read-more">Continue Reading...</a>
                </div>
            </div>
        </div>
    </article>';
	}
			}
		echo $html;	
	}

    /**
     *
     *
     *
     * AJAX
     *
     *
     *
     */

    /**
     * @param Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @todo Check if this is being used anymore
     * @deprecated
     */
    public function moreArticles(Request $request)
    {

        $limit  = $request->limit;
        $offset = $request->offset;

        $articles = Article::published()->where('top_article', '!=', '1')->whereNotIn('article_type_id', ['2', '7', '9'])->offset($offset)->limit($limit)->get();

        return view('site.partials.article.more_articles_content', compact('articles'));
    }

    public function article_categories()
    {

        $categories = ArticleType::whereSlug('article')->firstOrFail()->articleCategories->keyBy('slug');

        foreach ($categories as $key => $category) {
            $articles = $category->articles()->published()->limit(6)->get();

            $categories[$key]['top_article'] = $articles->shift();
            $categories[$key]['articles']    = $articles;
        }

        return view('site.partials.homepage.article_categories', compact('categories'));
    }

    public function events()
    {
        $current_date = Carbon::today();
        $months       = collect();
        $events       = Event::where([
            [
                'ended_at',
                '<=',
                $current_date->endOfMonth()->toDateString(),
            ],
            [
                'started_at',
                '>=',
                $current_date->startOfMonth()->toDateString(),
            ],
        ])->get();

        $months->push($current_date);

        for ($x = 1; $x < 12; $x++) {
            $current_date = Carbon::today();
            $current_date->addMonthNoOverflow($x);

            $months->push($current_date);
        }

        return [
            "months" => $months,
            "events" => $events,
        ];
        return view('site.partials.homepage.events', compact('events', 'months'));
    }
}
