<?php

namespace App\Http\Controllers;

use App\ArticleType;
use App\Http\Requests\PostedJobRequest;
use App\Jobs\SendJobPostEmail;
use App\PostedJob;
use Illuminate\Http\Request;
use Redirect;

class PostedJobsController extends Controller
{

    public function __construct()
    {

        $this->middleware('auth', [
            'except' => [
                'post_job',
                'post_job_email',
                'job_pricing',
                'thank_you',
                'job_form',
                'more_articles',
                'post_job_redirected',
                'post_job_email_redirected',
                'job_pricing_redirected',
                'thank_you_redirected',
                'job_form_redirected',
            ],
        ]);
    }

    /**
     *
     *
     *
     * CUSTOM ROUTE METHODS
     *
     *
     *
     */

    public function post_job()
    {

        return view('site.post_job');
    }

    public function job_form()
    {

        return view('site.partials.jobs.form');
    }

    public function post_job_email(PostedJobRequest $request)
    {

        //check if file is uploaded
        if (!empty($request->upload_logo)) {
            //move uploaded logo to another folder
            $request->upload_logo->move(storage_path('app/public/posted_job_logos'), $request->upload_logo->getClientOriginalName());

            //modify request data
            $request_data                = $request->all();
            $request_data['upload_logo'] = storage_path('app/public/posted_job_logos') . '/' . $request->upload_logo->getClientOriginalName();
        } else {
            $request_data = $request->all();
        }

        //save the data
        PostedJob::create($request_data);

        //email the data
        SendJobPostEmail::dispatch($request_data);

        return redirect('/job/thank-you');
    }

    public function job_pricing()
    {

        return view('site.job_pricing');
    }

    public function thank_you()
    {

        return view('site.job_thankyou');
    }

    public function post_job_redirected()
    {
        Redirect::to('/jobs/create', 301)->send();
    }

    public function job_form_redirected()
    {
        Redirect::to('/jobs/form', 301)->send();
    }

    public function post_job_email_redirected(PostedJobRequest $request)
    {
        Redirect::to('/jobs/post_job_email', 301)->send();
    }

    public function job_pricing_redirected()
    {
        Redirect::to('/jobs/pricing', 301)->send();
    }

    public function thank_you_redirected()
    {
        Redirect::to('/jobs/thank-you', 301)->send();
    }

    /**
     *
     *
     *
     *
     * AJAX METHODS
     *
     *
     *
     *
     */
}
