<?php

namespace App\Http\Controllers;

use App\Notifications\Article;
use App\User;
use Illuminate\Http\Request;
use Notification;
use NotificationChannels\WebPush\HasPushSubscriptions;
use Log;
use NotificationChannels\WebPush\PushSubscription;

class PushSubscriptionsController extends Controller
{

    use HasPushSubscriptions;

    public function store(Request $request)
    {

        Log::info($request);

        $user = User::first();

        $user->updatePushSubscription($request->endpoint, $request->keys['p256dh'], $request->keys['auth']);
    }

    public function sendNotification($article_id)
    {

        $user = User::first();

        Notification::send($user, new Article($article_id));
    }
}
