<?php

namespace App\Http\Controllers;

use App\Repositories\ScoutsRepository;
use Carbon\Carbon;
use Illuminate\Http\Request;

use App\Article;
use App\ArticleAuthor;
use App\ArticleMagazineEdition;
use App\ArticleMagazineMonth;
use App\ArticleType;
use App\ArticleCategory;
use App\Banner;
use App\Directory;
use App\Event;
use App\Newsletter;
use App\Repositories\ArticleCategoriesRepository;
use App\Repositories\ArticleAuthorsRepository;
use App\Repositories\ArticlesRepository;
use App\Repositories\ArticleTypesRepository;
use App\Repositories\BannersRepository;
use App\Repositories\DirectoriesRepository;
use App\Repositories\EmailMarketingRepository;
use App\Repositories\EventsRepository;
use App\Repositories\ArticleMagazineEditionsRepository;
use App\Repositories\ArticleMagazineMonthsRepository;
use App\Repositories\NewslettersRepository;
use App\Repositories\SubscribersRepository;
use App\Repositories\SubscriberSubTypesRepository;
use App\Repositories\SubscriberTypesRepository;
use App\Repositories\VideosRepository;
use App\Subscriber;
use App\Video;
use DB;
class ScoutsController extends Controller
{

    private $scoutsRepository;

    public function __construct(ScoutsRepository $scoutsRepository)
    {

        $this->middleware('auth', ['except' => ['search','searchnew']]);

        $this->scoutsRepository = $scoutsRepository;
    }

    /**
     * search for index page
     *
     * @param Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function adminSearch(Request $request)
    {

        $route_path   = $request->input('route_path'); //current route
        $current_path = $request->input('current_path'); //current route
        $query        = $request->input('query'); //current query string

        //find objects related to current route
        list($current_repository, $current_model) = $this->findClassesByRoute($route_path);

        //get the default or custom defined table path
        $current_table_path = method_exists($current_repository, 'getTablePath') ? $current_repository->getTablePath() : 'admin.partials.index_page.table';

        //using either default or custom search find relevant collection data based on search string
        $collection = method_exists($current_repository, 'search') ? $current_repository->search($request) : $current_model->search($query)->paginate(10);

        //set the correct path for paginated links otherwise it will say /search since that is where this call is coming from
        $collection->withPath($current_path);

        //return the view
        return view($current_table_path, $current_repository->indexElements(compact('collection')));
    }

    /**
     * Article Front End Search
     *
     * @param Request $request
     * @return string
     * @throws \Throwable
     */
    public function search(Request $request)
    {
		
		
        $query = $request->input('key');
		if(empty($query)) {
			return redirect('/');
		}
		 $searchValues = preg_split('/\s+/', $query, -1, PREG_SPLIT_NO_EMPTY); 
		/* $articles = Article::where(function ($q) use ($searchValues) {
			  foreach ($searchValues as $value) {
				$q->orWhere('title', 'like', "%{$value}%");
				$q->orWhere('sub_title', 'like', "%{$value}%");
				$q->orWhere('meta_title', 'like', "%{$value}%");
				$q->orWhere('meta_description', 'like', "%{$value}%");
				$q->orWhere('meta_keywords', 'like', "%{$value}%");
				$q->orWhere('content', 'like', "%{$value}%");
				$q->orWhere('slug', 'like', "%{$value}%");
				
			  }
		})->orderBy('published_at','desc')->paginate(10); */
		
								  $raw = "(";

    $raw .= "(articles.title LIKE '%".$query."%')+"; 
	/* $raw .= "(sub_title LIKE '%".$query."%')+";
	$raw .= "(meta_title LIKE '%".$query."%')+";
	$raw .= "(meta_description LIKE '%".$query."%')+";
	$raw .= "(meta_keywords LIKE '%".$query."%')+";
	$raw .= "(articles.slug LIKE '%".$query."%')+"; */
	$raw .= "(content LIKE '%".$query."%')+";
	$raw = substr($raw, 0, -1); 
	$raw .= ") as weight";

	$articles = Article::where('articles.title', 'LIKE', '%' . $query . '%')
							->select('articles.*','article_authors.firstname','article_authors.lastname')
							->join('article_authors','article_authors.id','=','articles.article_author_id')
							 ->orWhere(function ($qu) use ($searchValues) {
							foreach ($searchValues as $term) {
								$qu->where('article_authors.firstname', 'like', '%' . $term . '%');
							}
						}) ->orWhere(function ($qu) use ($searchValues) {
							foreach ($searchValues as $term) {
								$qu->where('article_authors.lastname', 'like', '%' . $term . '%');
							}
						})
							->orWhere('sub_title', 'LIKE', '%' . $query . '%')
                            ->orWhere('meta_title', 'LIKE', '%' . $query . '%')
                            ->orWhere('meta_description', 'LIKE', '%' . $query . '%')
                            ->orWhere('meta_keywords', 'LIKE', '%' . $query . '%')
                           ->orWhere(function ($qu) use ($searchValues) {
							foreach ($searchValues as $term) {
								$qu->where('content', 'like', '%' . $term . '%');
							}
						})
                            ->orWhere('articles.slug', 'LIKE', '%' . $query . '%')
							->addSelect(DB::raw($raw))
							->orderBy('articles.published_at','desc')->orderBy('weight','desc')->orderBy('article_authors.id','desc')->paginate(25);  
                           

        $now = Carbon::now();

        return view('site.partials.article.article_list_searchnew', compact('articles', 'query', 'now','searchValues'));
    }
	
	
	public function searchnew(Request $request)
    {
		
		
        $query = $request->input('key');
		 if(empty($query)) {
			return redirect('/');
		} 
		/* $searchValues = preg_split('/\s+/', $query, -1, PREG_SPLIT_NO_EMPTY); 
		$articles = Article::where(function ($q) use ($searchValues) {
			  foreach ($searchValues as $value) {
				$q->orWhere('title', 'like', "%{$value}%");
				$q->orWhere('sub_title', 'like', "%{$value}%");
				$q->orWhere('meta_title', 'like', "%{$value}%");
				$q->orWhere('meta_description', 'like', "%{$value}%");
				$q->orWhere('meta_keywords', 'like', "%{$value}%");
				$q->orWhere('content', 'like', "%{$value}%");
				$q->orWhere('slug', 'like', "%{$value}%");
				
			  }
		})->orderBy('published_at','desc')->paginate(10); */
		
// End result :
		 $searchnew = true;
		  $searchValues = preg_split('/\s+/', $query, -1, PREG_SPLIT_NO_EMPTY); 
		  $raw = "(";
foreach($searchValues as $key) {
    $raw .= "(article_authors.firstname LIKE '%".$key."%')+"; 
	$raw .= "(article_authors.lastname LIKE '%".$key."%')+";
		$raw .= "(content LIKE '%".$key."%')+";
		$raw .= "(articles.title LIKE '%".$key."%')+";
	
}
$raw = substr($raw, 0, -1); // Remove the last "+"
$raw .= ") as weight";
         $articles = Article::where(function ($q) use ($searchValues) {
			  foreach ($searchValues as $value) {
				$q->orWhere('article_authors.firstname', 'LIKE', '%' . $value . '%');
                $q->orWhere('article_authors.lastname', 'LIKE', '%' . $value . '%');
				 $q->orWhere('content', 'LIKE', '%' . $value . '%');
				 $q->orWhere('articles.title', 'LIKE', '%' . $value . '%');
				}
		})->select('articles.*','article_authors.firstname','article_authors.lastname')
							->join('article_authors','article_authors.id','=','articles.article_author_id')
							->addSelect(DB::raw($raw))
							 ->orderBy('weight','desc')->orderBy('published_at','desc')->paginate(10); 
							 
							 
                            
		
        $now = Carbon::now();
		
        return view('site.partials.article.article_list_searchnew', compact('articles', 'query', 'now','searchnew'));
    }

    /**
     * uses the provided route_path to find out which objects belong to that path
     *
     * @param $route_path
     *
     * @return array - returns repository and model objects
     */
    public function findClassesByRoute($route_path)
    {

        $current_repository = '';
        $current_model      = '';

        //check if the current route path has a set of objects to work with
        switch ($route_path) {
            case 'subscriber':
                $current_repository = new SubscribersRepository();
                $current_model      = new Subscriber();
                break;
            case 'video':
                $current_repository = new VideosRepository();
                $current_model      = new Video();
                break;
            case 'directory':
                $current_repository = new DirectoriesRepository();
                $current_model      = new Directory();
                break;
            case 'event':
                $current_repository = new EventsRepository();
                $current_model      = new Event();
                break;
            case 'banner':
                $current_repository = new BannersRepository();
                $current_model      = new Banner();
                break;
            case 'newsletter':
                $current_repository = new NewslettersRepository();
                $current_model      = new Newsletter();
                break;
            case 'magazine/month':
                $current_repository = new ArticleMagazineMonthsRepository();
                $current_model      = new ArticleMagazineMonth();
                break;
            case 'magazine/edition':
                $current_repository = new ArticleMagazineEditionsRepository();
                $current_model      = new ArticleMagazineEdition();
                break;
            case 'author':
                $current_repository = new ArticleAuthorsRepository();
                $current_model      = new ArticleAuthor();
                break;
            case 'article':
                $current_repository = new ArticlesRepository();
                $current_model      = new Article();
                break;
            case 'article/subtype':
                $current_repository = new ArticleCategoriesRepository();
                $current_model      = new ArticleCategory();
                break;
            case 'article/type':
                $current_repository = new ArticleTypesRepository();
                $current_model      = new ArticleType();
                break;
            case 'email_marketing':
                $current_repository = new EmailMarketingRepository();
                break;
        }

        //return objects
        return [
            $current_repository,
            $current_model,
        ];
    }
}
