<?php

namespace App\Http\Controllers;

use App\Repositories\ScoutsRepository;
use Carbon\Carbon;
use Illuminate\Http\Request;

use App\Article;
use App\ArticleAuthor;
use App\ArticleMagazineEdition;
use App\ArticleMagazineMonth;
use App\ArticleType;
use App\ArticleCategory;
use App\Banner;
use App\Directory;
use App\Event;
use App\Newsletter;
use App\Repositories\ArticleCategoriesRepository;
use App\Repositories\ArticleAuthorsRepository;
use App\Repositories\ArticlesRepository;
use App\Repositories\ArticleTypesRepository;
use App\Repositories\BannersRepository;
use App\Repositories\DirectoriesRepository;
use App\Repositories\EmailMarketingRepository;
use App\Repositories\EventsRepository;
use App\Repositories\ArticleMagazineEditionsRepository;
use App\Repositories\ArticleMagazineMonthsRepository;
use App\Repositories\NewslettersRepository;
use App\Repositories\SubscribersRepository;
use App\Repositories\SubscriberSubTypesRepository;
use App\Repositories\SubscriberTypesRepository;
use App\Repositories\VideosRepository;
use App\Subscriber;
use App\Video;

class ScoutsController extends Controller
{

    private $scoutsRepository;

    public function __construct(ScoutsRepository $scoutsRepository)
    {

        $this->middleware('auth', ['except' => 'search']);

        $this->scoutsRepository = $scoutsRepository;
    }

    /**
     * search for index page
     *
     * @param Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function adminSearch(Request $request)
    {

        $route_path   = $request->input('route_path'); //current route
        $current_path = $request->input('current_path'); //current route
        $query        = $request->input('query'); //current query string

        //find objects related to current route
        list($current_repository, $current_model) = $this->findClassesByRoute($route_path);

        //get the default or custom defined table path
        $current_table_path = method_exists($current_repository, 'getTablePath') ? $current_repository->getTablePath() : 'admin.partials.index_page.table';

        //using either default or custom search find relevant collection data based on search string
        $collection = method_exists($current_repository, 'search') ? $current_repository->search($request) : $current_model->search($query)->paginate(10);

        //set the correct path for paginated links otherwise it will say /search since that is where this call is coming from
        $collection->withPath($current_path);

        //return the view
        return view($current_table_path, $current_repository->indexElements(compact('collection')));
    }

    /**
     * Article Front End Search
     *
     * @param Request $request
     * @return string
     * @throws \Throwable
     */
    public function search(Request $request)
    {

        $query = $request->input('query');

        $articles = Article::search($query)->get()->where('published_at', '<=', Carbon::now())->where('published_at', '!=', '0000-00-00 00:00:00');

        return view('site.partials.article.article_list_search', compact('articles'))->render();
    }

    /**
     * uses the provided route_path to find out which objects belong to that path
     *
     * @param $route_path
     *
     * @return array - returns repository and model objects
     */
    public function findClassesByRoute($route_path)
    {

        $current_repository = '';
        $current_model      = '';

        //check if the current route path has a set of objects to work with
        switch ($route_path) {
            case 'subscriber':
                $current_repository = new SubscribersRepository();
                $current_model      = new Subscriber();
                break;
            case 'video':
                $current_repository = new VideosRepository();
                $current_model      = new Video();
                break;
            case 'directory':
                $current_repository = new DirectoriesRepository();
                $current_model      = new Directory();
                break;
            case 'event':
                $current_repository = new EventsRepository();
                $current_model      = new Event();
                break;
            case 'banner':
                $current_repository = new BannersRepository();
                $current_model      = new Banner();
                break;
            case 'newsletter':
                $current_repository = new NewslettersRepository();
                $current_model      = new Newsletter();
                break;
            case 'magazine/month':
                $current_repository = new ArticleMagazineMonthsRepository();
                $current_model      = new ArticleMagazineMonth();
                break;
            case 'magazine/edition':
                $current_repository = new ArticleMagazineEditionsRepository();
                $current_model      = new ArticleMagazineEdition();
                break;
            case 'author':
                $current_repository = new ArticleAuthorsRepository();
                $current_model      = new ArticleAuthor();
                break;
            case 'article':
                $current_repository = new ArticlesRepository();
                $current_model      = new Article();
                break;
            case 'article/subtype':
                $current_repository = new ArticleCategoriesRepository();
                $current_model      = new ArticleCategory();
                break;
            case 'article/type':
                $current_repository = new ArticleTypesRepository();
                $current_model      = new ArticleType();
                break;
            case 'email_marketing':
                $current_repository = new EmailMarketingRepository();
                break;
        }

        //return objects
        return [
            $current_repository,
            $current_model,
        ];
    }
}
