<?php

namespace App\Http\Controllers;

use Grids;
use Nayjest\Grids\Components\Base\RenderableRegistry;
use Nayjest\Grids\Components\FiltersRow;
use Nayjest\Grids\Components\Footer;
use Nayjest\Grids\Components\Header;
use Nayjest\Grids\Components\Pager;
use Nayjest\Grids\Components\RenderFunc;
use Nayjest\Grids\Components\ColumnsHider;
use App\Components\CustomExcelExport;
use Nayjest\Grids\Components\HtmlTag;
use Nayjest\Grids\Components\ColumnHeadersRow;
use Nayjest\Grids\Components\CsvExport;
use Nayjest\Grids\Components\Filters\DateRangePicker;
use Nayjest\Grids\Components\OneCellRow;
use Nayjest\Grids\Components\RecordsPerPage;
use Nayjest\Grids\Components\ShowingRecords;
use Nayjest\Grids\Components\TFoot;
use Nayjest\Grids\Components\THead;
use Nayjest\Grids\Components\TotalsRow;
use Nayjest\Grids\DataProvider;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\EloquentDataRow;
use Nayjest\Grids\FieldConfig;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\SelectFilterConfig;
use Nayjest\Grids\Grid;
use Nayjest\Grids\GridConfig;
use Nayjest\Grids\IdFieldConfig;
use Nayjest\Grids\ObjectDataRow;
use App\Components\GridTrById;
use App\Components\GridTrNotEditable;

use App\ArticleMagazineEdition;
use App\Jobs\PopulateMailingListTable;
use App\Jobs\ImportMailingListTable;
use App\Subscriber;
use App\Article;
use App\SubscriberIndustry;
use App\SubscriberSource;
use App\SubscriberChange;
use App\SubscriberPosition;
use App\SubscriberEducationLevel;
use App\SubscriberIncomeBracket;
use App\SubscriberAgeGroup;
use App\Country;
use App\ExportLog;
use App\User;
use App\ArticleMagazineMonth;
use App\Repositories\MailingListRepository;
use App\Repositories\SubscribersRepository;
use App\Repositories\MailWizzRepository;
use App\Http\Requests\SubscriberRequest;
use App\Jobs\CreateMailingListExcelSheet;
use App\Jobs\UpdateSubscriberEmail;
use App\Jobs\SyncSubscribers;
use App\Jobs\ExportChangedDataExcelSheet;
use App\Jobs\ExportMailingListExcelSheet;
use App\SubscriberRegion;
use Carbon\Carbon;
use DB;
use Exception;
use Illuminate\Contracts\Cookie\Factory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Schema;
use Mail;
use Input;
use Usps;
use Usps\AddressVerify;
use Usps\Address;
use App\Mail\ExportRequest;
use App\Mail\ExportApproved;
use MailWizzApi\Endpoint\ListSubscribers;
use Excel;

class SubscribersController extends Controller
{
    //Repositories
    private $subscriberRepository;
    /**
     * @var MailingListRepository
     */
    private $mailing_list_repository;

    /**
     * SubscribersController constructor.
     *
     * @param SubscribersRepository $subscribersRepository
     */
    public function __construct(SubscribersRepository $subscribersRepository, MailingListRepository $mailing_list_repository)
    {

        $this->middleware('auth', [
            'except' => [
                'set_region_question',
                'subscribe_thank_you',
                'index',
                'create_cookie',
                'send_subscriber_email',
                'store',
                'update',
                'update_subscriber',
                'update_subscriber_email',
                'update_subscriber_thank_you',
                'webHookUnsubscribe',
                'webHookSubscribe',
                'disapprove',
                'approve',
            ],
        ]);

        $this->subscriberRepository    = $subscribersRepository;
        $this->mailing_list_repository = $mailing_list_repository;
        $this->mailWizzRepository    = new MailWizzRepository('newsletter');
        $this->mailWizzDigitalRepository = new MailWizzRepository('digital');
    }

    /**
     *
     *
     *
     * CUSTOM ROUTE METHODS
     *
     *
     *
     */

    public function create_cookie(Request $request, Factory $cookie)
    {
        $request->session()->put('subscribe', 'subscribed');

        $cookie->queue($cookie->forever('subscribe', 'subscribed'));

        return 1;
    }

    public function send_subscriber_email(Request $request)
    {
        $email = $request->email;

        return view('site.send_subscriber_email', compact('email'));
    }

    public function unsubscribe_newsletter(Request $request)
    {

        $email      = decrypt($request->email);
        $subscriber = Subscriber::whereEmail($email)->firstOrFail();

        $subscriber->update([
            'newsletter' => 0,
        ]);

        $endpoint = new ListSubscribers();
        $response = $endpoint->unsubscribeByEmail('nk7723mkrcfbb', $email);

        return view('site.update_subscriber', $this->subscriberRepository->formElements(compact('subscriber', 'hide_hellobar', 'subscriptions')));
    }

    public function update_subscriber(Request $request)
    {

        $email      = decrypt($request->email);
        $subscriber = Subscriber::whereEmail($email)->firstOrFail();

        $subscriptions = [
            [
                'name'   => 'magazine',
                'title'  => 'Print Magazine',
                'status' => old('magazine', 0),
            ],
            [
                'name'   => 'digital',
                'title'  => 'Digital Magazine',
                'status' => old('digital', 1),
            ],
            [
                'name'   => 'newsletter',
                'title'  => 'Newsletter',
                'status' => old('newsletter', 1),
            ],
        ];

        $hide_hellobar = true;

        return view('site.update_subscriber', $this->subscriberRepository->formElements(compact('subscriber', 'hide_hellobar', 'subscriptions')));
    }

    public function update_magazine(Request $request)
    {

        $subscriber = Subscriber::find($request->subscriber_id);

        // save changes in subscriber_changes
        if ($request->magazine != $subscriber->magazine) {
            $authorid = Auth::user()->id;
            $useremail = null;
            if ($change = SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'magazine')->first()) {
                $change->update([
                    'author_id' => $authorid,
                    'user_email' => $useremail,
                    'value' => $subscriber->magazine,
                ]);
            } else {
                SubscriberChange::create([
                    'subscriber_id' => $subscriber->id,
                    'author_id' => $authorid,
                    'user_email' => $useremail,
                    'column_name' => 'magazine',
                    'value' => $subscriber->magazine,
                ]);
            }
        }

        $subscriber->update([
            'magazine' => $request->magazine,
        ]);

        return '<button type="button" title="' . ($subscriber->magazine == '1' ? 'Unsubscribe' : 'Subscribe') . '" onclick="update_magazine(this)"
        data-subscription_value="' . ($subscriber->magazine == '1' ? '0' : '1') . '" data-subscriber_id="' . $subscriber->id . '"
        class="btn ' . ($subscriber->magazine != '1' ? 'btn-danger' : 'btn-success') . '"><span class="' . ($subscriber->magazine != '1' ? 'glyphicon glyphicon-remove' : 'glyphicon glyphicon-ok') . '"></span></button>';
    }

    public function update_subscriber_thank_you()
    {

        return view('site.subscriber_update_thankyou');
    }

    public function subscribe_thank_you()
    {

        return view('site.subscriber_thankyou');
    }

    public function verify_address()
    {
        $subscribers = Subscriber::where('country_id', '=', 840)
            ->where('magazine', '=', 1)
            ->whereNull('address_verified')
            ->limit(200)->get(['id','address_1','address_2','city','subscriber_region_id','postal_code']);
        $verify = new AddressVerify('785WEBBR7314');
        foreach ($subscribers as $item) {
            if ($item->subscriber_region_id) {
                $regioncode = SubscriberRegion::findOrFail($item->subscriber_region_id)->code;
            } else {
                $regioncode = '';
            }
            $address = new Address();
            $address->setFirmName(null);
            $address->setApt($item->address_2);
            $address->setAddress($item->address_1);
            $address->setCity($item->city);
            $address->setState($regioncode);
            $address->setZip5($item->postal_code);
            $address->setZip4('');

            try {
                // Add the address object to the address verify class
                $verify->addAddress($address);
                // Perform the request and return result
                $val1 = $verify->verify();
                $val2 = $verify->getArrayResponse();

                // See if it was successful
                if (!$verify->isSuccess()) {
                    $item->address_verified = 0;
                } else {
                    $item->address_verified = 1;
                }
                $item->save();
            } catch (\Exception $e) {
            }
        }
        return Subscriber::where('country_id', '=', 840)
            ->where('magazine', '=', 1)
            ->whereNull('address_verified')->count();
    }

    public function mailing_list(Request $request)
    {
        $filter          = $request->filter;
        $filter_month_id = $request->filter_month_id;
        $filter_year     = $request->filter_year;
        $filters         = $this->subscriberRepository->getFilters();
        $months          = ArticleMagazineMonth::pluck('name', 'id');
        $current_year    = Carbon::now()->year;
        $next_year       = Carbon::now()->addYear()->year;
        $years           = [$current_year => $current_year, $next_year => $next_year];
        $printings       = ['magazine' => 'Print Magazine', 'digital' => 'Digital Magazine', 'newsletter' => 'Newsletter'];

        $subscriber_id = $request->subscriber_id;
        $address_verify = $request->address_verify;
        $request->session()->forget('warning');

        if ($subscriber_id) {
            $query = Subscriber::select('subscribers.*')
                ->where('magazine', '=', 1)
                ->where('subscribers.id', '=', $subscriber_id)
                ->leftJoin('countries', 'countries.id', '=', 'subscribers.country_id');
        } elseif ($address_verify) {
            $subscribers = Subscriber::where('country_id', '=', 840)
                ->where('magazine', '=', 1)
                ->whereNull('address_verified')
                ->limit(100)->get(['id','address_1','address_2','city','subscriber_region_id','postal_code']);
            $verify = new AddressVerify('785WEBBR7314');

            foreach ($subscribers as $item) {
                if (strpos(strtoupper($item->address_1), strtoupper('PO Box')) === false &&
                    strpos(strtoupper($item->address_1), strtoupper('P.O Box')) === false &&
                    strpos(strtoupper($item->address_1), strtoupper('P.O. Box')) === false) {
                    if ($item->subscriber_region_id) {
                        $regioncode = SubscriberRegion::findOrFail($item->subscriber_region_id)->code;
                    } else {
                        $regioncode = '';
                    }
                    $address = new Address();
                    $address->setFirmName(null);
                    $address->setApt($item->address_2);
                    $address->setAddress($item->address_1);
                    $address->setCity($item->city);
                    $address->setState($regioncode);
                    $address->setZip5($item->postal_code);
                    $address->setZip4('');

                    try {
                        // Add the address object to the address verify class
                        $verify->addAddress($address);
                        // Perform the request and return result
                        $val1 = $verify->verify();
                        $val2 = $verify->getArrayResponse();

                        // See if it was successful
                        if (!$verify->isSuccess()) {
                            $item->address_verified = 0;
                        } else {
                            $item->address_verified = 1;
                        }
                        $item->save();
                    } catch (\Exception $e) {
                    }
                }
            }
            $incorrect = Subscriber::where('country_id', '=', 840)
                ->where('magazine', '=', 1)
                ->where('address_verified', '!=', 1)->count();
            $request->session()->flash('warning', 'Found ' . $incorrect . ' records with incorrect address.');

            $query = Subscriber::select('subscribers.*')
                ->where('subscribers.country_id', '=', 840)
                ->where('subscribers.magazine', '=', 1)
                ->where('subscribers.address_verified', '!=', 1)
                ->leftJoin('countries', 'countries.id', '=', 'subscribers.country_id');
        } else {
            $query = Subscriber::select('subscribers.*')
                ->where('magazine', '=', 1)
                ->leftJoin('countries', 'countries.id', '=', 'subscribers.country_id');
        }

        $datagrid = (new GridConfig())
            ->setComponents([
                    (new THead())
                        ->setComponents([
                            (new ColumnHeadersRow()),
                            (new FiltersRow()),
                            (new OneCellRow())
                                ->setRenderSection(RenderableRegistry::SECTION_END)
                                ->setComponents([
                                    (new HtmlTag())->setTagName('a')
                                        ->setAttributes([
                                            'href' => '/' . \Request::path(),
                                            'class' => 'btn btn-sm btn-success'
                                        ])
                                        ->addComponent(new RenderFunc(function () {
                                            return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                        })),
                                    (new HtmlTag())->setTagName('a')
                                        ->setAttributes([
                                            'href' => '/' . \Request::path() . '?address_verify=1',
                                            'class' => 'btn btn-sm btn-danger'
                                        ])
                                        ->addComponent(new RenderFunc(function () {
                                            return 'Check Address';
                                        })),
                                    (new HtmlTag())
                                        ->setAttributes(['class' => 'pull-right'])
                                        ->addComponent(new ShowingRecords()),
                                ])
                        ]),(new TFoot()),
                ])
            ->setDataProvider(
                new EloquentDataProvider($query)
            )
            ->setRowComponent(new GridTrNotEditable())
            ->setName('filter')
            ->setPageSize(150)
            ->setColumns([
                // (new FieldConfig('magazine'))->setLabel('Print Magazine')->setCallback(function ($val, ObjectDataRow $row) {
                //   $subscriber = $row->getSrc();
                //   return '<button type="button" title="'.($subscriber->magazine == '1' ? 'Unsubscribe' : 'Subscribe').'" onclick="update_magazine(this)"
                //   data-subscription_value="'.($subscriber->magazine == '1' ? '0' : '1').'" data-subscriber_id="'.$subscriber->id.'"
                //   class="btn '.($subscriber->magazine != '1' ? 'btn-danger' : 'btn-success').'"><span class="'.($subscriber->magazine != '1' ? 'glyphicon glyphicon-remove' : 'glyphicon glyphicon-ok').'"></span></button>';
                // })->addFilter((new SelectFilterConfig)
                //     ->setName('magazine')
                //     ->setOptions([
                //         '1'=>'Subscribed',
                //         '0'=>'Unsubscribed'
                //     ])
                //     ->setSubmittedOnChange(true)
                // ),
                (new FieldConfig('company'))->setLabel('Company Name')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $span = '<span class="input-group-btn"><a class="btn btn-default" target="_blank" href="https://www.google.com/search?q=' . urlencode($subscriber->company) . '">></a></span>';
                        $input = '<input class="subscriber_update form-control" data-subscriber_id="' . $subscriber->id . '" name="company" type="text" value="' . $subscriber->company . '">';
                        return '<div class="input-group">' . $input . $span . '</div>';
                    }),
                (new FieldConfig('firstname'))->setLabel('First Name')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $input = '<input class="subscriber_update form-control" data-subscriber_id="' . $subscriber->id . '" name="firstname" type="text" value="' . $subscriber->firstname . ' ">';
                        return $input;
                    }),
                (new FieldConfig('lastname'))->setLabel('Last Name')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $input = '<input class="subscriber_update form-control" data-subscriber_id="' . $subscriber->id . '" name="lastname" type="text" value="' . $subscriber->lastname . ' ">';
                        return $input;
                    }),
                (new FieldConfig('address_1'))->setLabel('Address 1')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $span = '<span class="input-group-btn"><a class="btn btn-default" target="_blank" href="https://www.google.com/search?q=' . urlencode($subscriber->address_1) . '">></a></span>';
                        $input = '<input class="subscriber_update form-control" data-subscriber_id="' . $subscriber->id . '" name="address_1" type="text" value="' . $subscriber->address_1 . '">';
                        return '<div class="input-group">' . $input . $span . '</div>';
                    }),
                (new FieldConfig('address_2'))->setLabel('Address 2')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $input = '<input class="subscriber_update form-control" data-subscriber_id="' . $subscriber->id . '" name="address_2" type="text" value="' . $subscriber->address_2 . '">';
                        return $input;
                    }),
                (new FieldConfig('city'))->setLabel('City')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $input = '<input class="subscriber_update form-control" data-subscriber_id="' . $subscriber->id . '" name="city" type="text" value="' . $subscriber->city . '">';
                        return $input;
                    }),
                (new FieldConfig('postal_code'))->setLabel('Postal Code')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $input = '<input class="subscriber_update form-control" data-subscriber_id="' . $subscriber->id . '" name="postal_code" type="text" value="' . $subscriber->postal_code . '">';
                        return $input;
                    }),
                (new FieldConfig('region'))->setLabel('Region')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $input = '<input class="subscriber_update form-control" data-subscriber_id="' . $subscriber->id . '" name="region" type="text" value="' . $subscriber->region . '">';
                        return $input;
                    }),
                (new FieldConfig())->setLabel('Country')->setName('name')
                    ->addFilter((new SelectFilterConfig())
                        ->setName('name')
                        ->setOptions([
                            'domestic' => 'Domestic',
                            'foreign' => 'Foreign'
                        ])
                        ->setSubmittedOnChange(true)
                        ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                            if ($val == 'domestic') {
                                $provider->getBuilder()->where('country_id', '=', 840);
                            } else {
                                $provider->getBuilder()->where('country_id', '!=', 840);
                            }
                        }))->setSortable(true)
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $countries = Country::orderBy('name')->get();
                        $input = '<select class="subscriber_update set_region form-control" data-subscriber_id="' . $subscriber->id . '" name="country_id"><option value="">Countries</option>';
                        foreach ($countries as $country) {
                            if ($country->id == $subscriber->country_id) {
                                $selected = 'selected';
                            } else {
                                $selected = '';
                            }
                            $input .= '<option value="' . $country->id . '" ' . $selected . '>' . $country->name . '</option>';
                        }
                        $input .= '</select>';
                        return $input;
                    }),
            ]);

        $grid = new Grid($datagrid);
        $grid = $grid->render();
        return view('admin.subscribers.mailing_list.index', compact('grid', 'filter', 'filter_month_id', 'filter_year', 'months', 'filters', 'years', 'printings'));
    }

    public function admin(Request $request)
    {
        $epage = 1;
        if (\Request::has('exported_page')) {
            $epage = \Request::get('exported_page');
        }

        $query = Subscriber::select('subscribers.*')
            ->leftJoin('countries', 'countries.id', '=', 'subscribers.country_id')
            ->leftJoin('subscriber_positions', 'subscriber_positions.id', '=', 'subscribers.subscriber_position_id')
            ->leftJoin('subscriber_industries', 'subscriber_industries.id', '=', 'subscribers.subscriber_industry_id');

        $columns = [
            (new FieldConfig('subscribers.id'))->setLabel('Subscriber ID')
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    return $subscriber->id;
                })
                ->addFilter((new FilterConfig())
                ->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
            (new FieldConfig('created_at'))->setLabel('Created')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
            (new FieldConfig('email'))
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
            (new FieldConfig('firstname'))->setLabel('First Name')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
            (new FieldConfig('lastname'))->setLabel('Last Name')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
            (new FieldConfig('company'))->setLabel('Company')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
            (new FieldConfig())->setLabel('Country Type')->setName('countries.name')
                ->addFilter((new SelectFilterConfig())
                    ->setName('name')
                    ->setOptions([
                        'domestic' => 'Domestic',
                        'foreign' => 'Foreign'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        if ($val == 'domestic') {
                            $provider->getBuilder()->where('country_id', '=', 840);
                        } else {
                            $provider->getBuilder()->where('country_id', '!=', 840);
                        }
                    }))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $country = Country::find($subscriber->country_id);
                        if ($country) {
                            return $country->name;
                        } else {
                            return '';
                        }
                    }),
            (new FieldConfig())->setLabel('Country')->setName('subscribers.country_id')
                ->addFilter((new FilterConfig())->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                    $ids = [];
                    $countries = Country::get()
                        ->filter(function ($item) use ($val) {
                            return (strpos(strtolower($item->name), strtolower($val)) !== false);
                        });
                    foreach ($countries as $country) {
                        $ids [] = $country->id;
                    }
                    $provider->getBuilder()->whereIn('country_id', $ids);
                }))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    $country = Country::find($subscriber->country_id);
                    if ($country) {
                        return $country->name;
                    } else {
                        return '';
                    }
                }),
            (new FieldConfig('subscriber_industry_id'))->setLabel('Industry')
                ->addFilter((new FilterConfig())->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                    $ids = [];
                    $industries = SubscriberIndustry::get()
                        ->filter(function ($item) use ($val) {
                            return (strpos(strtolower($item->name), strtolower($val)) !== false);
                        });
                    foreach ($industries as $industry) {
                        $ids [] = $industry->id;
                    }
                    $provider->getBuilder()->whereIn('subscriber_industry_id', $ids);
                }))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    $industry = SubscriberIndustry::find($subscriber->subscriber_industry_id);
                    if ($industry) {
                        return $industry->name;
                    } else {
                        return '';
                    }
                }),
            (new FieldConfig('subscriber_position_id'))->setLabel('Position')
                ->addFilter((new FilterConfig())->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                    $ids = [];
                    $positions = SubscriberPosition::get()
                        ->filter(function ($item) use ($val) {
                            return (strpos(strtolower($item->name), strtolower($val)) !== false);
                        });
                    foreach ($positions as $position) {
                        $ids [] = $position->id;
                    }
                    $provider->getBuilder()->whereIn('subscriber_position_id', $ids);
                }))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    $position = SubscriberPosition::find($subscriber->subscriber_position_id);
                    if ($position) {
                        return $position->name;
                    } else {
                        return '';
                    }
                }),
            (new FieldConfig('magazine'))
                ->addFilter((new SelectFilterConfig())
                    ->setOptions([
                        '1' => 'Subscribed',
                        '0' => 'Unsubscribed'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        $provider->getBuilder()->where('magazine', '=', $val);
                    }))
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    return '<span style="visibility:hidden">' . $subscriber->magazine . '</span><button type="button" title="' . ($subscriber->magazine == '0' ? 'Unsubscribed' : 'Subscribed') . '" '
                    . 'data-subscription="magazine" '
                    . 'data-subscription_value="' . ($subscriber->magazine == '0' ? '' : '1') . '" '
                    . 'data-subscriber_id="' . $subscriber->id . '" class="subscriptions btn ' . ($subscriber->magazine == '0' ? 'btn-danger' : 'btn-success') . '"><span class="' . ($subscriber->magazine == '0' ? 'glyphicon glyphicon-remove' : 'glyphicon glyphicon-ok') . '"></span></button>';
                }),
            (new FieldConfig('digital'))
                ->addFilter((new SelectFilterConfig())
                    ->setOptions([
                        '1' => 'Subscribed',
                        '0' => 'Unsubscribed'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        $provider->getBuilder()->where('digital', '=', $val);
                    }))
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    return '<span style="visibility:hidden">' . $subscriber->digital . '</span><button type="button" title="' . ($subscriber->digital == '0' ? 'Unsubscribed' : 'Subscribed') . '" '
                    . 'data-subscription="digital" '
                    . 'data-subscription_value="' . ($subscriber->digital == '0' ? '' : '1') . '" '
                    . 'data-subscriber_id="' . $subscriber->id . '" class="subscriptions btn ' . ($subscriber->digital == '0' ? 'btn-danger' : 'btn-success') . '"><span class="' . ($subscriber->digital == '0' ? 'glyphicon glyphicon-remove' : 'glyphicon glyphicon-ok') . '"></span></button>';
                }),
            (new FieldConfig('newsletter'))
                ->addFilter((new SelectFilterConfig())
                    ->setOptions([
                        '1' => 'Subscribed',
                        '0' => 'Unsubscribed'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        $provider->getBuilder()->where('newsletter', '=', $val);
                    }))
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    return '<span style="visibility:hidden">' . $subscriber->newsletter . '</span><button type="button" title="' . ($subscriber->newsletter == '0' ? 'Unsubscribed' : 'Subscribed') . '" '
                    . 'data-subscription="newsletter" '
                    . 'data-subscription_value="' . ($subscriber->newsletter == '0' ? '' : '1') . '" '
                    . 'data-subscriber_id="' . $subscriber->id . '" class="subscriptions btn ' . ($subscriber->newsletter == '0' ? 'btn-danger' : 'btn-success') . '"><span class="' . ($subscriber->newsletter == '0' ? 'glyphicon glyphicon-remove' : 'glyphicon glyphicon-ok') . '"></span></button>';
                }),
            (new FieldConfig('email_marketing'))
                ->addFilter((new SelectFilterConfig())
                    ->setOptions([
                        '1' => 'Subscribed',
                        '0' => 'Unsubscribed'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        $provider->getBuilder()->where('email_marketing', '=', $val);
                    }))
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    return '<span style="visibility:hidden">' . $subscriber->email_marketing . '</span><button type="button" title="' . ($subscriber->email_marketing == '0' ? 'Unsubscribed' : 'Subscribed') . '" '
                    . 'data-subscription="email_marketing" '
                    . 'data-subscription_value="' . ($subscriber->email_marketing == '0' ? '' : '1') . '" '
                    . 'data-subscriber_id="' . $subscriber->id . '" class="subscriptions btn ' . ($subscriber->email_marketing == '0' ? 'btn-danger' : 'btn-success') . '"><span class="' . ($subscriber->email_marketing == '0' ? 'glyphicon glyphicon-remove' : 'glyphicon glyphicon-ok') . '"></span></button>';
                }),
        ];

        if (Auth::user()->id == 5 || Auth::user()->role == 1) {
            if (ExportLog::where('email', '=', Auth::user()->email)->where('approved_at', '>=', Carbon::now()->subHours(12))->whereNotNull('approved_at')->first()
                    || Auth::user()->role == 1) {
                $datagrid = (new GridConfig())
                    ->setComponents([
                            (new THead())
                                ->setComponents([
                                    (new ColumnHeadersRow()),
                                    (new FiltersRow()),
                                    (new OneCellRow())
                                        ->setRenderSection(RenderableRegistry::SECTION_END)
                                        ->setComponents([
                                            (new HtmlTag())->setTagName('a')
                                                ->setAttributes([
                                                    'href' => '/' . \Request::path(),
                                                    'class' => 'btn btn-sm btn-success'
                                                ])
                                            ->addComponent(new RenderFunc(function () {
                                                return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                            })),
                                            new ColumnsHider(),
                                            (new HtmlTag())->setTagName('label')
                                                ->setAttributes([
                                                    'title' => '5000 Records In Page',
                                                ])
                                            ->addComponent(new RenderFunc(function () {
                                                return 'Page To Export';
                                            })),
                                            (new HtmlTag())->setTagName('select')
                                                ->setAttributes([
                                                    'name' => 'exported_page',
                                                    'onchange' => 'this.form.submit()',
                                                    'class' => 'btn btn-sm btn-default'
                                                ])
                                            ->addComponent(new RenderFunc(function () use ($query, $epage) {
                                                $gridpage = new EloquentDataProvider($query);
                                                $records_count = $gridpage->getPaginator()->total();
                                                $page_count = ceil($records_count / 5000);

                                                $options = '<option value="1">1</option>';
                                                for ($i = 2; $i <= $page_count; $i++) {
                                                    if ($epage == $i) {
                                                        $selected = 'selected';
                                                    } else {
                                                        $selected = '';
                                                    }
                                                    $options .= '<option value="' . $i . '" ' . $selected . '>' . $i . '</option>';
                                                }
                                                return $options;
                                            })),
                                            (new CustomExcelExport())->setFileName('subsctibers(' . $epage . ')_' . date('m-d-Y'))->setPage($epage),
                                            (new HtmlTag())
                                                ->setAttributes(['class' => 'pull-right'])
                                                ->addComponent(new ShowingRecords()),
                                        ])
                                ]),(new TFoot()),
                        ])
                    ->setRowComponent(new GridTrById())
                    ->setDataProvider(
                        new EloquentDataProvider($query)
                    )
                    ->setName('filter')
                    ->setPageSize(150)
                    ->setColumns($columns);
            } else {
                $datagrid = (new GridConfig())
                    ->setComponents([
                            (new THead())
                                ->setComponents([
                                    (new ColumnHeadersRow()),
                                    (new FiltersRow()),
                                    (new OneCellRow())
                                        ->setRenderSection(RenderableRegistry::SECTION_END)
                                        ->setComponents([
                                            (new HtmlTag())->setTagName('a')
                                                ->setAttributes([
                                                    'href' => '/' . \Request::path(),
                                                    'class' => 'btn btn-sm btn-success'
                                                ])
                                            ->addComponent(new RenderFunc(function () {
                                                return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                            })),
                                            new ColumnsHider(),
                                            (new HtmlTag())
                                                ->setContent('<span class="glyphicon glyphicon-export"></span> Request Excel Download')
                                                ->setTagName('button')
                                                ->setAttributes([
                                                    'type' => 'button',
                                                    'class' => 'btn btn-sm btn-default',
                                                    'id' => 'request_excel_download'
                                                ]),
                                            (new HtmlTag())
                                                ->setAttributes(['class' => 'pull-right'])
                                                ->addComponent(new ShowingRecords()),
                                        ])
                                ]),(new TFoot()),
                        ])
                    ->setRowComponent(new GridTrById())
                    ->setDataProvider(
                        new EloquentDataProvider($query)
                    )
                    ->setName('filter')
                    ->setPageSize(150)
                    ->setColumns($columns);
            }
        } else {
            $datagrid = (new GridConfig())
                ->setComponents([
                        (new THead())
                            ->setComponents([
                                (new ColumnHeadersRow()),
                                (new FiltersRow()),
                                (new OneCellRow())
                                    ->setRenderSection(RenderableRegistry::SECTION_END)
                                    ->setComponents([
                                        (new HtmlTag())->setTagName('a')
                                            ->setAttributes([
                                                'href' => '/' . \Request::path(),
                                                'class' => 'btn btn-sm btn-success'
                                            ])
                                        ->addComponent(new RenderFunc(function () {
                                            return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                        })),
                                        new ColumnsHider(),
                                        (new HtmlTag())
                                            ->setAttributes(['class' => 'pull-right'])
                                            ->addComponent(new ShowingRecords()),
                                    ])
                            ]),(new TFoot()),
                    ])
                ->setRowComponent(new GridTrById())
                ->setDataProvider(
                    new EloquentDataProvider($query)
                )
                ->setName('filter')
                ->setPageSize(150)
                ->setColumns($columns);
        }

        $grid = new Grid($datagrid);
        $grid = $grid->render();
        $create_button_title = 'Create';
        $route_path = explode('/', \Request::path())[0];

        \Session::put('back_url', $request->fullUrl());

        return view('admin.subscribers.index', compact('grid', 'create_button_title', 'route_path'));
    }

    public function changed_data_report(Request $request)
    {
        // $changegroups = SubscriberChange::where('author_id','=',16)
        //             ->whereBetween('updated_at', [Carbon::parse('2018-09-28'), Carbon::parse('2018-10-23')])
        //             ->groupBy('subscriber_id')->limit(20)->get();
        //
        // $columns = Schema::getColumnListing('subscribers');
        //
        // foreach ($changegroups as $group) {
        //     $subscriber = Subscriber::findOrFail($group->subscriber_id);
        //
        //     foreach ($columns as $cname) {
        //         if ($ch = SubscriberChange::where('author_id','=',16)->where('subscriber_id','=',$group->subscriber_id)
        //                     ->where('column_name','=',$cname)
        //                     ->whereBetween('updated_at', [Carbon::parse('2018-09-28'), Carbon::parse('2018-10-23')])
        //                     ->first()) {
        //             $subscriber->$cname = $ch->value;
        //             $subscriber->save();
        //             if ($cname == 'newsletter' || $cname == 'digital') {
        //                 $this->subscriberRepository->syncSubscriptionLists($subscriber);
        //             }
        //             foreach (SubscriberChange::where('author_id','=',16)->where('subscriber_id','=',$group->subscriber_id)
        //                         ->where('column_name','=',$cname)
        //                         ->whereBetween('updated_at', [Carbon::parse('2018-09-28'), Carbon::parse('2018-10-23')])
        //                         ->get() as $change) {
        //                 $change->delete();
        //             }
        //         }
        //     }
        // }
        // return count(SubscriberChange::where('author_id','=',16)
        //             ->whereBetween('updated_at', [Carbon::parse('2018-09-28'), Carbon::parse('2018-10-23')])
        //             ->groupBy('subscriber_id')->get());

        $sids = SubscriberChange::pluck('subscriber_id');

        if (\Request::has('from') && \Request::has('to')) {
            $from_date = \Request::get('from');
            $to_date = Carbon::parse(\Request::get('to'))->addDays(1);

            $exportlink = '/subscriber/changed-data-export?from=' . $from_date . '&to=' . $to_date;

            $query = Subscriber::select('subscribers.*')
                ->whereIn('subscribers.id', $sids)
                ->whereBetween('subscribers.updated_at', [$from_date, $to_date])
                ->leftJoin('countries', 'countries.id', '=', 'subscribers.country_id')
                ->leftJoin('subscriber_positions', 'subscriber_positions.id', '=', 'subscribers.subscriber_position_id')
                ->leftJoin('subscriber_industries', 'subscriber_industries.id', '=', 'subscribers.subscriber_industry_id');
        } else {
            $exportlink = '/subscriber/changed-data-export';

            $query = Subscriber::select('subscribers.*')
                ->whereIn('subscribers.id', $sids)
                ->leftJoin('countries', 'countries.id', '=', 'subscribers.country_id')
                ->leftJoin('subscriber_positions', 'subscriber_positions.id', '=', 'subscribers.subscriber_position_id')
                ->leftJoin('subscriber_industries', 'subscriber_industries.id', '=', 'subscribers.subscriber_industry_id');
        }

        $columns = [
            (new FieldConfig('subscriber_id'))
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    return $row->getSrc()->id;
                }),
            (new FieldConfig('email'))
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'email')->first() ? 'text-danger' : '') . '">' . $row->getSrc()->email . '</span>';
                }),
            (new FieldConfig('firstname'))->setLabel('First Name')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'firstname')->first() ? 'text-danger' : '') . '">' . $row->getSrc()->firstname . '</span>';
                }),
            (new FieldConfig('lastname'))->setLabel('Last Name')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'lastname')->first() ? 'text-danger' : '') . '">' . $row->getSrc()->lastname . '</span>';
                }),
            (new FieldConfig('company'))->setLabel('Company')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'company')->first() ? 'text-danger' : '') . '">' . $row->getSrc()->company . '</span>';
                }),
            (new FieldConfig('address_1'))->setLabel('Address 1')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'address_1')->first() ? 'text-danger' : '') . '">' . $row->getSrc()->address_1 . '</span>';
                }),
            (new FieldConfig('address_2'))->setLabel('Address 2')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'address_2')->first() ? 'text-danger' : '') . '">' . $row->getSrc()->address_2 . '</span>';
                }),
            (new FieldConfig('city'))->setLabel('City')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'city')->first() ? 'text-danger' : '') . '">' . $row->getSrc()->city . '</span>';
                }),
            (new FieldConfig('postal_code'))->setLabel('Postal Code')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'postal_code')->first() ? 'text-danger' : '') . '">' . $row->getSrc()->postal_code . '</span>';
                }),
            (new FieldConfig('region'))->setLabel('Region')
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                    if ($row->getSrc()->subscriberRegion) {
                        $region = $row->getSrc()->subscriberRegion->name;
                    } else {
                        $region = $row->getSrc()->region;
                    }
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'region')->first() ? 'text-danger' : '') . '">' . $region . '</span>';
                }),
            (new FieldConfig())->setLabel('Country')->setName('countries.name')
                ->addFilter((new SelectFilterConfig())
                    ->setName('name')
                    ->setOptions([
                        'domestic' => 'Domestic',
                        'foreign' => 'Foreign'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        if ($val == 'domestic') {
                            $provider->getBuilder()->where('country_id', '=', 840);
                        } else {
                            $provider->getBuilder()->where('country_id', '!=', 840);
                        }
                    }))->setSortable(true)->setCallback(function ($val, ObjectDataRow $row) {
                        $subscriber = $row->getSrc();
                        $country = Country::find($subscriber->country_id);
                        if ($country) {
                            return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'country_id')->first() ? 'text-danger' : '') . '">' . $country->name . '</span>';
                        } else {
                            return '';
                        }
                    }),
            (new FieldConfig('subscriber_source_id'))->setLabel('Source')
                ->addFilter((new FilterConfig())->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                    $ids = [];
                    $sources = SubscriberSource::get()
                        ->filter(function ($item) use ($val) {
                            return (strpos(strtolower($item->name), strtolower($val)) !== false);
                        });
                    foreach ($sources as $i) {
                        $ids [] = $i->id;
                    }
                    $provider->getBuilder()->whereIn('subscriber_source_id', $ids);
                }))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    $source = SubscriberSource::find($subscriber->subscriber_source_id);
                    if ($source) {
                        return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'subscriber_source_id')->first() ? 'text-danger' : '') . '">' . $source->name . '</span>';
                    } else {
                        return '';
                    }
                }),
            (new FieldConfig('subscriber_industry_id'))->setLabel('Industry')
                ->addFilter((new FilterConfig())->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                    $ids = [];
                    $industries = SubscriberIndustry::get()
                        ->filter(function ($item) use ($val) {
                            return (strpos(strtolower($item->name), strtolower($val)) !== false);
                        });
                    foreach ($industries as $industry) {
                        $ids [] = $industry->id;
                    }
                    $provider->getBuilder()->whereIn('subscriber_industry_id', $ids);
                }))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    $industry = SubscriberIndustry::find($subscriber->subscriber_industry_id);
                    if ($industry) {
                        return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'subscriber_industry_id')->first() ? 'text-danger' : '') . '">' . $industry->name . '</span>';
                    } else {
                        return '';
                    }
                }),
            (new FieldConfig('position_title'))
                ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'position_title')->first() ? 'text-danger' : '') . '">' . $row->getSrc()->position_title . '</span>';
                }),
            (new FieldConfig('subscriber_position_id'))->setLabel('Position')
                ->addFilter((new FilterConfig())->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                    $ids = [];
                    $positions = SubscriberPosition::get()
                        ->filter(function ($item) use ($val) {
                            return (strpos(strtolower($item->name), strtolower($val)) !== false);
                        });
                    foreach ($positions as $position) {
                        $ids [] = $position->id;
                    }
                    $provider->getBuilder()->whereIn('subscriber_position_id', $ids);
                }))->setSortable(true)
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    $position = SubscriberPosition::find($subscriber->subscriber_position_id);
                    if ($position) {
                        return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $row->getSrc()->id)->where('column_name', '=', 'subscriber_position_id')->first() ? 'text-danger' : '') . '">' . $position->name . '</span>';
                    } else {
                        return '';
                    }
                }),
            (new FieldConfig('magazine'))
                ->addFilter((new SelectFilterConfig())
                    ->setOptions([
                        '1' => 'Subscribed',
                        '0' => 'Unsubscribed'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        $provider->getBuilder()->where('magazine', '=', $val);
                    }))
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'magazine')->first() ? 'text-danger' : '') . '">' . ($subscriber->magazine == '0' ? 'Unsubscribed' : 'Subscribed') . '</span>';
                }),
            (new FieldConfig('digital'))
                ->addFilter((new SelectFilterConfig())
                    ->setOptions([
                        '1' => 'Subscribed',
                        '0' => 'Unsubscribed'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        $provider->getBuilder()->where('digital', '=', $val);
                    }))
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'digital')->first() ? 'text-danger' : '') . '">' . ($subscriber->digital == '0' ? 'Unsubscribed' : 'Subscribed') . '</span>';
                }),
            (new FieldConfig('newsletter'))
                ->addFilter((new SelectFilterConfig())
                    ->setOptions([
                        '1' => 'Subscribed',
                        '0' => 'Unsubscribed'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        $provider->getBuilder()->where('newsletter', '=', $val);
                    }))
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'newsletter')->first() ? 'text-danger' : '') . '">' . ($subscriber->newsletter == '0' ? 'Unsubscribed' : 'Subscribed') . '</span>';
                }),
            (new FieldConfig('email_marketing'))
                ->addFilter((new SelectFilterConfig())
                    ->setOptions([
                        '1' => 'Subscribed',
                        '0' => 'Unsubscribed'
                    ])
                    ->setSubmittedOnChange(true)
                    ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                        $provider->getBuilder()->where('email_marketing', '=', $val);
                    }))
                ->setCallback(function ($val, ObjectDataRow $row) {
                    $subscriber = $row->getSrc();
                    return '<span class="' . (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'email_marketing')->first() ? 'text-danger' : '') . '">' . ($subscriber->email_marketing == '0' ? 'Unsubscribed' : 'Subscribed') . '</span>';
                }),
        ];

        $datagrid = (new GridConfig())
            ->setComponents([
                    (new THead())
                        ->setComponents([
                            (new ColumnHeadersRow()),
                            (new FiltersRow()),
                            (new OneCellRow())
                                ->setRenderSection(RenderableRegistry::SECTION_END)
                                ->setComponents([
                                    (new HtmlTag())->setTagName('a')
                                        ->setAttributes([
                                            'href' => '/' . \Request::path(),
                                            'class' => 'btn btn-sm btn-success'
                                        ])
                                    ->addComponent(new RenderFunc(function () {
                                        return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                    })),
                                    (new HtmlTag())->setTagName('a')
                                        ->setAttributes([
                                            'href' => $exportlink,
                                            'class' => 'btn btn-sm btn-default'
                                        ])
                                    ->addComponent(new RenderFunc(function () {
                                        return '<i class="glyphicon glyphicon-export"></i> Excel Export';
                                    })),
                                    // (new CustomExcelExport)->setFileName('subsctibers_changes' . date('m-d-Y')),
                                    (new HtmlTag())
                                        ->setAttributes(['class' => 'pull-right'])
                                        ->addComponent(new ShowingRecords()),
                                ])
                        ]),(new TFoot()),
                ])
            ->setDataProvider(
                new EloquentDataProvider($query)
            )
            ->setRowComponent(new GridTrById())
            ->setName('filter')
            ->setPageSize(50)
            ->setColumns($columns);

        $grid = new Grid($datagrid);
        $grid = $grid->render();

        return view('admin.subscribers.changed_data_report', compact('grid'));
    }

    public function changed_data_export(Request $request)
    {
        $sids = SubscriberChange::pluck('subscriber_id');

        if (\Request::has('from') && \Request::has('to')) {
            $from_date = \Request::get('from');
            $to_date = Carbon::parse(\Request::get('to'))->addDays(1);

            $subscribers = Subscriber::whereIn('id', $sids)
                        ->whereBetween('updated_at', [$from_date, $to_date])->get();
        } else {
            $subscribers = Subscriber::whereIn('id', $sids)->get();
        }

        ExportChangedDataExcelSheet::dispatch($subscribers);
    }

    public function mailing_list_export(Request $request)
    {
        $sid = $request->ids;

        $subscribers = Subscriber::whereIn('id', explode(',', $sid))->get();

        ExportMailingListExcelSheet::dispatch($subscribers);
    }

    public function get_changes(Request $request)
    {
        $subscriber_id = $request->subscriber_id;

        $changes = SubscriberChange::where('subscriber_id', '=', $subscriber_id)->get();
        $subscriber = Subscriber::find($subscriber_id);

        $response = '';

        foreach ($changes as $change) {
            $column_name = $change->column_name;
            if ($change->author_id != null && User::find($change->author_id)) {
                $author = User::find($change->author_id)->name;
            } else {
                $author = $change->user_email;
            }
            $response .= '<div class="changed-item">
                <div class="change-item-name"><b>' . $column_name . '</b>: <span class="text-danger">old value - ' . $change->value . '</span>, <span class="text-success">new value - ' . $subscriber->$column_name . '</span></div>
                <div class="change-author"><b>Changed by</b> <span>' . $author . '</span>, <i>' . $change->updated_at . '</i></div>
            </div><hr>';
        }

        return $response;
    }

    public function history_export()
    {
        if (Auth::user()->role == 1) {
            $query = ExportLog::select('export_logs.*')->orderBy('created_at', 'desc');

            $columns = [
                (new FieldConfig('name'))
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
                (new FieldConfig('email'))
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
                (new FieldConfig('created_at'))->setLabel('Requested Date')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
                (new FieldConfig('approved_at'))->setLabel('Approved Date')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
                (new FieldConfig('exported_at'))->setLabel('Exported Date')
                    ->addFilter((new FilterConfig())->setOperator(FilterConfig::OPERATOR_LIKE))->setSortable(true),
                (new FieldConfig())
                    ->setCallback(function ($val, ObjectDataRow $row) {
                        $item = $row->getSrc();
                        if ($item->approved_at == null) {
                            return '<a class="btn btn-success btn-block" href="/subscriber/approve/' . $item->id . '">Approve</a>';
                        }
                        return '<a class="btn btn-danger btn-block" href="/subscriber/disapprove/' . $item->id . '">Disapprove</a>';
                    }),
            ];

            $datagrid = (new GridConfig())
                ->setComponents([
                        (new THead())
                            ->setComponents([
                                (new ColumnHeadersRow()),
                                (new FiltersRow()),
                                (new OneCellRow())
                                    ->setRenderSection(RenderableRegistry::SECTION_END)
                                    ->setComponents([
                                        (new HtmlTag())->setTagName('a')
                                        ->setAttributes([
                                            'href' => '/' . \Request::path(),
                                            'class' => 'btn btn-sm btn-success'
                                        ])
                                        ->addComponent(new RenderFunc(function () {
                                            return '<i class="glyphicon glyphicon-refresh"></i> Clear';
                                        })),
                                        (new HtmlTag())
                                            ->setAttributes(['class' => 'pull-right'])
                                            ->addComponent(new ShowingRecords()),
                                    ])
                            ]),(new TFoot()),
                    ])
                ->setDataProvider(
                    new EloquentDataProvider($query)
                )
                ->setName('filter')
                ->setPageSize(150)
                ->setColumns($columns);

            $grid = new Grid($datagrid);
            $grid = $grid->render();

            return view('admin.subscribers.history_export', compact('grid'));
        }
        return redirect('/article');
    }

    public function send_request(Request $request)
    {
        $exportLog = ExportLog::create([
            'name' => $request->name,
            'email' => $request->email,
        ]);

        if ($exportLog) {
            $user = User::whereEmail($request->email)->firstOrFail();
            $requestId = $exportLog->id;

            $admins = User::where('role', '=', 1)->get();

            foreach ($admins as $admin) {
                Mail::to($admin->email, $admin->name)->send(new ExportRequest($user, $requestId, $admin->email));
            }

            return back()->with('message', 'Your request was successfully sent!');
        } else {
            return back()->with('error', 'Something went wrong please try again later.');
        }
    }

    public function approve($id)
    {
        if ($email = \Request::get('email')) {
            $user = User::where('email', '=', $email)->first();
            Auth::login($user);
        }

        $exportLog = ExportLog::find($id);

        $exportLog->update([
            'approved_at' => date("Y-m-d H:i:s"),
        ]);

        $username = $exportLog->name;

        Mail::to($exportLog->email, $exportLog->name)->send(new ExportApproved($username));

        return redirect('/subscriber/export/history')->with('message', 'Request was successfully approved!');
    }

    public function disapprove($id)
    {
        if ($email = \Request::get('email')) {
            $user = User::where('email', '=', $email)->first();
            Auth::login($user);
        }

        $exportLog = ExportLog::find($id);

        $exportLog->update([
            'approved_at' => null,
        ]);

        return redirect('/subscriber/export/history')->with('error', 'Request was successfully disapproved!');
    }

    public function export(Request $request)
    {
        $exportLog = ExportLog::where('email', '=', Auth::user()->email)->where('approved_at', '>=', Carbon::now()->subHours(12))->first();

        $exportLog->update([
            'exported_at' => date("Y-m-d H:i:s"),
        ]);
    }

    /**
     * Queue up creation of mailing list
     */
    public function create_mailing_list(Request $request)
    {

        $article_magazine_month_id = $request->month;
        $year                      = $request->year;
        $printing                  = $request->printing;
        $user                      = Auth::user();

        $article_magazine_month = ArticleMagazineMonth::findOrFail($article_magazine_month_id);
        $table_name             = $this->mailing_list_repository->mailing_list_table_name($article_magazine_month, $year, $printing);

        if (!Schema::hasTable($table_name)) {
            return 'FALSE';
        }

        CreateMailingListExcelSheet::dispatch($article_magazine_month_id, $year, $printing, $user);

        return 'TRUE';
    }

    public function daily_subscribers_report()
    {
        if (\Request::has('from') && \Request::has('to')) {
            $from_date = \Request::get('from');
            $to_date = Carbon::parse(\Request::get('to'))->addDays(1);

            $daily_subscribers_report = DB::connection('newsletter')
                                            ->select(DB::raw('SELECT date, list_id, COUNT(date) AS total,
                                                COUNT(IF(list_id = 4, list_id, NULL)) AS dcount,
                                                COUNT(IF(list_id = 5, list_id, NULL)) AS ncount
                                            FROM (SELECT DATE_FORMAT(date_added, "%Y-%m-%d %W") AS date, list_id FROM mw_list_subscriber
                                            WHERE ((list_id = "4" OR list_id = "5") AND date_added BETWEEN "' . $from_date . '" AND "' . $to_date . '"))
                                            AS item GROUP BY date ORDER BY date DESC'));
        } else {
            $daily_subscribers_report = DB::connection('newsletter')
                                            ->select(DB::raw('SELECT date, list_id, COUNT(date) AS total,
                                                COUNT(IF(list_id = 4, list_id, NULL)) AS dcount,
                                                COUNT(IF(list_id = 5, list_id, NULL)) AS ncount
                                            FROM (SELECT DATE_FORMAT(date_added, "%Y-%m-%d %W") AS date, list_id FROM mw_list_subscriber
                                            WHERE (list_id = "4" OR list_id = "5")) AS item GROUP BY date ORDER BY date DESC'));
        }
        // $columns = DB::connection('newsletter')->select(DB::raw('SELECT * FROM mw_list'));
        //
        // return $columns;
        return view('admin.subscribers.daily_subscribers_report', compact('daily_subscribers_report'));
    }

    public function list_subscribers_report($date, $listid)
    {
        $list_subscribers_report = DB::connection('newsletter')
                ->select(DB::raw('SELECT * FROM mw_list_subscriber WHERE DATE_FORMAT(date_added, "%Y-%m-%d") = "' . $date . '" AND list_id = "' . $listid . '"'));
        $list_name = DB::connection('newsletter')
                ->select(DB::raw('SELECT * FROM mw_list WHERE list_id = "' . $listid . '"'))[0]->display_name;

        return view('admin.subscribers.list_subscribers_report', compact('list_subscribers_report', 'list_name', 'date'));
    }

    public function get_dates(Request $request)
    {

        $article_magazine_month_id = $request->article_magazine_month_id;
        $year                      = $request->year;

        $article_magazine_month = ArticleMagazineMonth::findOrFail($article_magazine_month_id);

        $period = $this->mailing_list_repository->mailing_list_period($article_magazine_month, $year);

        return $period;
    }
    /**
     *
     *
     *
     * RESTFUL METHODS
     *
     *
     *
     */

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $subscriptions = [
            [
                'name'   => 'magazine',
                'title'  => 'Print Magazine',
                'status' => old('magazine', 1),
            ],
            [
                'name'   => 'digital',
                'title'  => 'Digital Magazine',
                'status' => old('digital', 1),
            ],
            [
                'name'   => 'newsletter',
                'title'  => 'Newsletter',
                'status' => old('newsletter', 1),
            ],
        ];
        $top_stories = Article::published()
            ->where('top_article', '!=', '1')
            ->whereNotIn('article_type_id', ['2', '7', '9'])
            ->limit(4)
            ->get();
        return view('site.subscribe', $this->subscriberRepository->formElements(compact('subscriptions', 'top_stories')));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (\Session::get('back_url')) {
            $back_url = \Session::get('back_url');
        } else {
            $back_url = '/subscriber/admin';
        }

        return view($this->subscriberRepository->getAdminFolderPath() . '.create', $this->subscriberRepository->formElements(), compact('back_url'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($request->magazine == 1) {
            if ($request->country_id == 840 && strpos(strtoupper($request->address_1), strtoupper('PO Box')) === false &&
                strpos(strtoupper($request->address_1), strtoupper('P.O Box')) === false &&
                strpos(strtoupper($request->address_1), strtoupper('P.O. Box')) === false) {
                $this->validate($request, [
                    'email' => 'required|email|unique:subscribers',
                    'address_1' => 'required',
                    'city' => 'required',
                    'subscriber_region_id' => 'required',
                    'postal_code' => 'required',
                    'country_id' => 'required',
                    'subscriber_industry_id' => 'required',
                    'subscriber_position_id' => 'required',
                ], [
                    'email.unique' => 'The email has already been subscribed.',
                    'subscriber_region_id.required' => 'The State/Province field is required.',
                    'country_id.required' => 'The Country field is required.',
                    'subscriber_industry_id.required' => 'The Industry field is required.',
                    'subscriber_position_id.required' => 'The Position field is required.'
                ]);
                $verify = new AddressVerify('785WEBBR7314');
                $address = new Address();
                $address->setFirmName(null);
                $address->setApt($request->address_2);
                $address->setAddress($request->address_1);
                $address->setCity($request->city);
                $address->setState(SubscriberRegion::findOrFail($request->subscriber_region_id)->code);
                $address->setZip5($request->postal_code);
                $address->setZip4('');

                // Add the address object to the address verify class
                $verify->addAddress($address);
                // Perform the request and return result
                $val1 = $verify->verify();
                $val2 = $verify->getArrayResponse();

                // See if it was successful
                if (!$verify->isSuccess()) {
                    // return back()->withInput(Input::all())->with(['error' => $verify->getErrorMessage()]);
                    return back()->withInput(Input::all())->with(['error' => 'Invalid Address']);
                }
            } else {
                $this->validate($request, [
                    'email' => 'required|email|unique:subscribers',
                    'address_1' => 'required',
                    'city' => 'required',
                    'country_id' => 'required',
                    'subscriber_industry_id' => 'required',
                    'subscriber_position_id' => 'required',
                ], [
                    'email.unique' => 'The email has already been subscribed.',
                    'country_id.required' => 'The Country field is required.',
                    'subscriber_industry_id.required' => 'The Industry field is required.',
                    'subscriber_position_id.required' => 'The Position field is required.'
                ]);
            }
        } else {
            $this->validate($request, [
                'email' => 'required|email|unique:subscribers',
            ], [
                'email.unique' => 'The email has already been subscribed.'
            ]);
        }

        //create new subscriber
        $subscriber = Subscriber::create($request->all());

        //sync the subscriber to mailwizz servers
        $this->subscriberRepository->syncSubscriptionLists($subscriber);

        // Method is used by the frontend as well so this check prevents it from sending back unnecessary information
        if (Auth::user()) {
            //return to the subscriber index page
            return redirect('/subscribe/thank-you'); //redirect($request->back_url);
        } else {
            // send back the new subscriber id
            return redirect('/subscribe/thank-you');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Subscriber $subscriber)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Subscriber $subscriber)
    {
        if (\Session::get('back_url')) {
            $back_url = \Session::get('back_url');
        } else {
            $back_url = '/subscriber/admin';
        }

        return view($this->subscriberRepository->getAdminFolderPath() . '.edit', $this->subscriberRepository->formElements(compact('subscriber', 'back_url')));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(SubscriberRequest $request, Subscriber $subscriber)
    {
        Log::info('Updating subscriber');

        if ($request->magazine == 1) {
            if ($request->country_id == 840 && (strpos(strtoupper($request->address_1), strtoupper('PO Box')) === false &&
                strpos(strtoupper($request->address_1), strtoupper('P.O Box')) === false &&
                strpos(strtoupper($request->address_1), strtoupper('P.O. Box')) === false)) {
                $verify = new AddressVerify('785WEBBR7314');
                $address = new Address();
                $address->setFirmName(null);
                $address->setApt($request->address_2);
                $address->setAddress($request->address_1);
                $address->setCity($request->city);
                $address->setState(SubscriberRegion::findOrFail($request->subscriber_region_id)->code);
                $address->setZip5($request->postal_code);
                $address->setZip4('');

                // Add the address object to the address verify class
                $verify->addAddress($address);
                // Perform the request and return result
                $val1 = $verify->verify();
                $val2 = $verify->getArrayResponse();

                // See if it was successful
                if (!$verify->isSuccess()) {
                    // return back()->withInput(Input::all())->with(['error' => $verify->getErrorMessage()]);
                    return back()->withInput(Input::all())->with(['error' => 'Invalid Address']);
                }
            }
        }

        // save changes in subscriber_changes
        foreach ($request->except(['_token', '_method', 'subscriber_education_level_id', 'subscriber_income_bracket_id', 'subscriber_age_group_id']) as $key => $part) {
            if ($request->$key != $subscriber->$key) {
                if (Auth::user()) {
                    $authorid = Auth::user()->id;
                    $useremail = null;
                } else {
                    $authorid = null;
                    $useremail = $subscriber->email;
                }
                $authorid = Auth::user()->id;
                $useremail = null;
                if ($newchange = SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', $key)->first()) {
                    $newchange->update([
                        'author_id' => $authorid,
                        'user_email' => $useremail,
                        'value' => $subscriber->$key,
                    ]);
                } else {
                    SubscriberChange::create([
                        'subscriber_id' => $subscriber->id,
                        'author_id' => $authorid,
                        'user_email' => $useremail,
                        'column_name' => $key,
                        'value' => $subscriber->$key,
                    ]);
                }
            }
        }
        // update the subscriber
        $subscriber->update($request->all());

        //sync the subscriber to mailwizz servers
        $this->subscriberRepository->syncSubscriptionLists($subscriber);

        if ($request->newsletter == 1 || $request->digital == 1 || $subscriber->newsletter == 1 || $subscriber->digital == 1) {
            $newsletter_id = $this->mailWizzRepository->getListUid();
            $digital_id = $this->mailWizzDigitalRepository->getListUid();

            $endpoint = new ListSubscribers();

            $response1 = $endpoint->emailSearch($newsletter_id, $subscriber->email)->body->toArray();
            $response2 = $endpoint->emailSearch($digital_id, $subscriber->email)->body->toArray();

            if ($response1['status'] == 'error' && $response2['status'] == 'error') {
                $errormessage = $response1["error"];
                return back()->withInput(Input::all())->with(['error' => 'This email address is blacklisted!']);
            }
        }

        //Method is used by the frontend as well so this check prevents it from sending back unnecessary information
        if (Auth::user()) {
            return redirect($request->back_url);
        } else {
            return redirect('/subscriber/update-subscriber/thank-you');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Subscriber $subscriber)
    {

        try {
            $subscriber->delete();
        } catch (Exception $e) {
            Log::debug($e);
        }

        return redirect('subscriber/admin');
    }

    /**
     *
     *
     * AJAX METHODS
     *
     *
     */

    /**
     * @param Request $request
     */
    public function update_subscription(Request $request)
    {
        $subscription       = $request->subscription;
        $subscriber_id      = $request->subscriber_id;
        $subscription_value = $request->subscription_value;

        //Subscribe the user
        Subscriber::findOrFail($subscriber_id)->update([$subscription => $subscription_value]);

        $subscriber = Subscriber::findOrFail($subscriber_id);

        $this->subscriberRepository->updateSubscription($subscriber, $subscription);

        return $subscriber->{$subscription};
    }

    /**
     * Unsubscribe via Webhook
     *
     * @param Request $request
     */
    public function webHookUnsubscribe(Request $request)
    {

        Log::info('Unsubscribe Webhook');

        //GET data from WebHook
        $list_uid = $request->data['list']['list_uid'];
        $email    = $request->data['subscriber']['email'];

        $subscription = $this->subscriberRepository->getSubscriptionTypeByListUid($list_uid);

        Log::info($list_uid);
        Log::info($email);
        Log::info($subscription);

        //Unsubscribe the user
        Subscriber::where('email', $email)->update([$subscription => 0]);
    }

    /**
     * Subscribe via Webhook
     *
     * @param Request $request
     */
    public function webHookSubscribe(Request $request)
    {
        Log::info('Subscribe Webhook');

        //GET data from WebHook
        $list_uid = $request->data['list']['list_uid'];
        $email    = $request->data['subscriber']['email'];

        $subscription = $this->subscriberRepository->getSubscriptionTypeByListUid($list_uid);

        Log::info($list_uid);
        Log::info($email);

        //Subscribe the user
        Subscriber::where('email', $email)->update([$subscription => '1']);
    }

    /**
     * @param Request $request
     */
    public function update_subscriber_email(Request $request)
    {
        $this->validate($request, [
            'email' => 'required|email|exists:subscribers,email',
        ], [
            'email.exists' => 'This email address is not subscribed.'
        ]);

        $email = $request->email;

        //create the job to send the email
        dispatch((new UpdateSubscriberEmail($email)));

        return view('site.subscriber_email_sent_thankyou', compact('email'));
    }

    public function mailing_list_filter(Request $request, Subscriber $subscriber)
    {

        $filter            = $request->filter;
        $countries         = Country::orderBy('name')->pluck('name', 'id');
        $regions           = SubscriberRegion::orderBy('name')->pluck('name', 'id');
        $subscribers       = Subscriber::magazine();
        $subscribers       = $this->subscriberRepository->mailing_list_filters($filter, $subscribers);
        $subscribers_count = $subscribers->count();
        $subscribers       = $subscribers->paginate(100)->appends(['filter' => $filter]);

        return view('admin.subscribers.mailing_list.partials.filter_data', compact('subscribers', 'countries', 'regions', 'subscribers_count'));
    }

    public function mailing_list_filters(Request $request)
    {

        $mailing_list = $request->mailing_list;

        $return_data['age_of_source_data']              = $this->mailing_list_repository->age_of_source_data($mailing_list);
        $return_data['business_and_occupation']         = $this->mailing_list_repository->business_and_occupation($mailing_list);
        $return_data['geographic_canada']               = $this->mailing_list_repository->geographic_canada($mailing_list);
        $return_data['geographic_international']        = $this->mailing_list_repository->geographic_international($mailing_list);
        $return_data['geographic_poss_and_other_areas'] = $this->mailing_list_repository->geographic_poss_and_other_areas($mailing_list);
        $return_data['geographic_us_alaska_and_hawaii'] = $this->mailing_list_repository->geographic_us_alaska_and_hawaii($mailing_list);
        $return_data['geographic_us_states']            = $this->mailing_list_repository->geographic_us_states($mailing_list);
        $return_data['geographic_us_military']          = $this->mailing_list_repository->geographic_us_military($mailing_list);
        $return_data['geographic_us_classified']        = $this->mailing_list_repository->geographic_us_classified($mailing_list);
        $return_data['issue_by_issue']                  = $this->mailing_list_repository->issue_by_issue($mailing_list);
        $return_data['mailing_address']                 = $this->mailing_list_repository->mailing_address($mailing_list);

        return view('admin.subscribers.audit.partials.filters', $return_data);
    }

    public function create_mailing_list_table(Request $request)
    {

        $article_magazine_month_id = $request->article_magazine_month_id;
        $year                      = $request->year;
        $printing                  = $request->printing;

        $article_magazine_month = ArticleMagazineMonth::findOrFail($article_magazine_month_id);
        $table_name             = $this->mailing_list_repository->mailing_list_table_name($article_magazine_month, $year, $printing);

        //stop running if table already exists
        if (Schema::hasTable($table_name)) {
            return 'FALSE';
        }

        $edition = ArticleMagazineEdition::where([
                                             ['year', $year],
                                             ['article_magazine_month_id', $article_magazine_month_id],
                                         ])->get();

        if ($edition->isEmpty()) {
            ArticleMagazineEdition::create([
                                       'year'                      => $year,
                                       'article_magazine_month_id' => $article_magazine_month_id,
                                   ]);
        }

        //create the table
        DB::connection('mysql')->statement('CREATE TABLE `' . $table_name . '` LIKE subscribers;');

        //request that the table be populated
        PopulateMailingListTable::dispatch($article_magazine_month, $year, $printing);

        return 'TRUE';
    }

    public function set_region_question($type)
    {

        $regions = SubscriberRegion::orderBy('name')->pluck('name', 'id');

        return view('admin.subscribers.partials.' . $type, compact('regions'));
    }

    public function set_mailing_list_region_question($type, Request $request)
    {

        $subscriber_id = $request->subscriber_id;

        $regions    = SubscriberRegion::orderBy('name')->pluck('name', 'id');
        $subscriber = Subscriber::findOrFail($subscriber_id);

        return view('admin.subscribers.mailing_list.partials.' . $type, compact('regions', 'subscriber'));
    }

    public function sync()
    {
        $newsletter_id = $this->mailWizzRepository->getListUid();
        $digital_id = $this->mailWizzDigitalRepository->getListUid();

        $endpoint = new ListSubscribers();

        // Sync Newsletter
        $response = $endpoint->getSubscribers($newsletter_id, $pageNumber = 1, $perPage = 50);
        if ($response->body['status'] == 'success') {
            for ($i = 2001; $i <= 2192; $i++) {
                $subresponse = $endpoint->getSubscribers($newsletter_id, $pageNumber = $i, $perPage = 50);
                foreach ($subresponse->body['data']['records'] as $item) {
                    if ($item["status"] == "confirmed") {
                        $status = 1;
                    } else {
                        $status = 0;
                    }
                    if ($subscriber = Subscriber::whereEmail($item["EMAIL"])->first()) {
                        if ($subscriber->newsletter != $status) {
                            $subscriber->update([
                                'newsletter' => $status
                            ]);
                        }
                    } else {
                        Subscriber::create([
                            'firstname' => $item["FNAME"],
                            'lastname' => $item["LNAME"],
                            'email' => $item["EMAIL"],
                            'digital' => 0,
                            'magazine' => 0,
                            'newsletter' => $status,
                            'email_marketing' => 0,
                            'subscriber_source_id' => 1,
                        ]);
                    }
                }
            }
        }

        // Sync Digital
        // $response = $endpoint->getSubscribers($digital_id, $pageNumber = 1, $perPage = 50);
        // if ($response->body['status'] == 'success') {
        //     for ($i=1; $i <= 592; $i++) {
        //         $subresponse = $endpoint->getSubscribers($digital_id, $pageNumber = $i, $perPage = 50);
        //         foreach ($subresponse->body['data']['records'] as $item) {
        //             if ($item["status"] == "confirmed") {
        //                 $status = 1;
        //             } else {
        //                 $status = 0;
        //             }
        //             if ($subscriber = Subscriber::whereEmail($item["EMAIL"])->first()) {
        //                 if ($subscriber->digital != $status) {
        //                     $subscriber->update([
        //                         'digital' => $status
        //                     ]);
        //                 }
        //             } else {
        //                 Subscriber::create([
        //                     'firstname' => $item["FNAME"],
        //                     'lastname' => $item["LNAME"],
        //                     'email' => $item["EMAIL"],
        //                     'digital' => $status,
        //                     'magazine' => 0,
        //                     'newsletter' => 0,
        //                     'email_marketing' => 0,
        //                     'subscriber_source_id' => 1,
        //                 ]);
        //             }
        //         }
        //     }
        // }

        return $response->body['data']['total_pages'];
    }

    public function not_in_mailwizz()
    {
        $newsletter_id = $this->mailWizzRepository->getListUid();
        $digital_id = $this->mailWizzDigitalRepository->getListUid();
        //
        // $subscribers = Subscriber::where('newsletter','=',0)
        //                         ->where('magazine','=',0)
        //                         ->where('digital','=',0)
        //                         ->where('email_marketing','=',0)
        //                         ->limit(1000)->get();
        //
        $count = 0;
        //
        // foreach ($subscribers as $subscriber) {
        //     $endpoint = new ListSubscribers();
        //     $response1 = $endpoint->emailSearch($newsletter_id, $subscriber->email)->body->toArray();
        //     $response2 = $endpoint->emailSearch($digital_id, $subscriber->email)->body->toArray();
        //
        //     // var_dump($response1);
        //
        //     if ($response1['status'] == 'error' && $response2['status'] == 'error'
        //         || $response1['status'] == 'error' && $response2['data']["status"] != 'confirmed'
        //         || $response1['data']["status"] != 'confirmed' && $response2['status'] == 'error'
        //         || $response1['data']["status"] != 'confirmed' && $response2['data']["status"] != 'confirmed') {
        //
        //
        //          if ($response1['status'] == 'error' && $response2['status'] == 'error') {
        //              echo "--"."_" . "--" . '<br>';
        //          } elseif ($response1['status'] == 'error' && $response2['data']["status"] != 'confirmed') {
        //              echo "string2-".$response2['data']["subscriber_uid"] . '<br>';
        //
        //              $newresponse2 = $endpoint->delete($digital_id, $response2['data']["subscriber_uid"]);
        //          } elseif ($response1['data']["status"] != 'confirmed' && $response2['status'] == 'error') {
        //              echo "string1-".$response1['data']["subscriber_uid"].'<br>';
        //
        //              $newresponse1 = $endpoint->delete($newsletter_id, $response1['data']["subscriber_uid"]);
        //          } elseif ($response1['data']["status"] != 'confirmed' && $response2['data']["status"] != 'confirmed') {
        //
        //              echo "string1-".$response1['data']["subscriber_uid"] ."_" . "string2-".$response2['data']["subscriber_uid"] . '<br>';
        //              $newresponse1 = $endpoint->delete($newsletter_id, $response1['data']["subscriber_uid"]);
        //              $newresponse2 = $endpoint->delete($digital_id, $response2['data']["subscriber_uid"]);
        //          }
        //          $subscriber->delete();
        //          $count++;
        //     } else {
        //         echo "none<br>";
        //     }

        //     if ($response1 != 'error' && $response2 != 'error') {
        //         $newendpoint = new ListSubscribers();
        // $response = $endpoint->delete('LIST-UNIQUE-ID', 'SUBSCRIBER-UNIQUE-ID');

        //         $new = $newendpoint->create($newsletter_id, array(
        //             'EMAIL'    => $subscriber->email,
        //             'FNAME'    => $subscriber->firstname,
        //             'LNAME'    => $subscriber->lastname,
        //         ));
        //         if ($new->body->toArray()['status'] == "success") {
        //             $count++;
        //             $subscriber->update([
        //                 'in_mailwizz' => 1
        //             ]);
        //             echo $subscriber->email . '</br>';
        //         } else {
        //             if ($subscriber->digital == 0 && $subscriber->magazine == 0 && $subscriber->email_marketing == 0) {
        //                 $subscriber->delete();
        //             }
        //             $subscriber->newsletter=0;
        //             $subscriber->save();
        //             echo $subscriber->email . '-not newsletter </br>';
        //         }
        //     } else {
        //         $subscriber->update([
        //             'in_mailwizz' => 2
        //         ]);
        //     }
        // }
        return $count . '-' . Subscriber::where('newsletter', '=', 0)
                                ->where('magazine', '=', 0)
                                ->where('digital', '=', 0)
                                ->where('email_marketing', '=', 0)
                                ->count();
    }

    public function audit()
    {
        $editions = ArticleMagazineEdition::orderBy('year', 'DESC')->orderBy('article_magazine_month_id', 'DESC')->get();

        $options = '<option value="">Select Edition</option>';
        $data_options = '<option value="">Select</option>';

        foreach ($editions as $edition) {
            $options .= '<option value="' . $edition->getFullEditionTableNameAttribute() . '">' . $edition->getFullEditionDateAttribute() . '</option>';
            $data_options .= '<option value="mailing_list' . $edition->getFullEditionTableNameAttribute() . '">' . $edition->getFullEditionDateAttribute() . '</option>';
        }

        return view('admin.subscribers.audit.index', compact('options', 'data_options'));
    }

    public function import_excel(Request $request)
    {
        $request->validate([
            'edition' => 'required',
            'import_file' => 'required|max:2048'
        ], [
            'import_file.max' => 'The import file may not be greater than 2MB.'
        ]);

        $table_name = 'mailing_list' . $request->edition;
        $path = $request->file('import_file')->getRealPath();
        $data = Excel::load($path)->get();

        try {
            if ($data->count()) {
                foreach ($data as $key => $value) {
                    if (isset($value->email)) {
                        if (Country::where('site_subscriber_translation', '=', $value->country)->first()) {
                            $countryId = Country::where('site_subscriber_translation', '=', $value->country)->first()->id;
                        } else {
                            $countryId = null;
                        }
                        $arr[] = ['id' => $value->customer_id, 'company' => $value->company, 'firstname' => $value->first_name,
                                    'lastname' => $value->last_name, 'address_1' => $value->address_1, 'address_2' => $value->address_2,
                                    'city' => $value->city, 'region' => $value->region, 'postal_code' => $value->postal_code,
                                    'country_id' => $countryId, 'email' => $value->email, 'start_date' => Carbon::parse($value->start_date), 'end_date' => Carbon::parse($value->end_date),
                                    'process_status' => $value->process_status, 'sent' => $value->sent, 'date_added' => $value->date_added
                                ];
                    } else {
                        foreach ($value as $k => $v) {
                            if (Country::where('site_subscriber_translation', '=', $v->country)->first()) {
                                $countryId = Country::where('site_subscriber_translation', '=', $v->country)->first()->id;
                            } else {
                                $countryId = null;
                            }
                            $arr[] = ['id' => $v->customer_id, 'company' => $v->company, 'firstname' => $v->first_name,
                                        'lastname' => $v->last_name, 'address_1' => $v->address_1, 'address_2' => $v->address_2,
                                        'city' => $v->city, 'region' => $v->region, 'postal_code' => $v->postal_code,
                                        'country_id' => $countryId, 'email' => $v->email, 'start_date' => Carbon::parse($v->start_date), 'end_date' => Carbon::parse($v->end_date),
                                        'process_status' => $v->process_status, 'sent' => $v->sent, 'date_added' => $v->date_added
                                    ];
                        }
                    }
                }
            }

            $filename = $request->import_file->getClientOriginalName();
            //request that the table be populated
            ImportMailingListTable::dispatch($filename, $table_name, $arr);

            return response()->json([
                        'message' => 'File was imported successfully!',
                        'status' => 200
                    ], 200);
        } catch (\Exception $e) {
            return response()->json([
                    'message' => 'Error! ' . $e,
                    'status' => 400
                ], 400);
        }
    }

    public function getfiles()
    {
        $files = DB::table('mailing_list_file_name')->select('file_name', 'table_name')->groupBy('file_name')->get();

        $output = '';

        foreach ($files as $file) {
            $output .= '<div class="well">
                <span class="text-primary">' . $file->file_name . '</span>
                <form class="pull-right" action="' . route('removefile') . '" method="post" onsubmit="return ConfirmDelete()">
                    ' . csrf_field() . '
                    <input type="hidden" name="file_name" value="' . $file->file_name . '">
                    <input type="hidden" name="table_name" value="' . $file->table_name . '">
                    <button type="submit" class="glyphicon glyphicon-trash"></button>
                </form>
            </div>';
        }

        return $output;
    }

    public function removefile(Request $request)
    {
        $tablename = $request->table_name;
        $filename = $request->file_name;

        $records = DB::table('mailing_list_file_name')->where('file_name', '=', $filename)->get();

        foreach ($records as $record) {
            DB::table($tablename)->where('id', '=', $record->record_id)->delete();
            DB::table('mailing_list_file_name')->where('id', '=', $record->id)->delete();
        }

        return back()->with('message', 'File ' . $filename . ' was removed successfully!');
        ;
    }

    // public function audit()
    // {
    //     $mailing_lists = DB::table('information_schema.tables')
    //                        ->select('table_name AS mailing_list', DB::raw('REPLACE(REPLACE(table_name, \'_\', \' \'), \'mailing-list \', \' \') AS title'))
    //                        ->where('table_name', 'LIKE', '%mailing_list%')
    //                        ->orderBy('table_name', 'DESC')
    //                        ->pluck('title', 'mailing_list');
    //
    //     return view('admin.subscribers.audit.index', compact('mailing_lists'));
    // }
}
