<?php

namespace App\Http\Controllers;

use App\Http\Requests\VideoRequest;
use App\Repositories\VideosRepository;
use App\Video;
use Illuminate\Http\Request;

class VideosController extends Controller
{

    protected $videosRepository;

    public function __construct(VideosRepository $videosRepository)
    {

        $this->middleware('auth');

        $this->videosRepository = $videosRepository;
    }

    public function index()
    {
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function admin(Request $request)
    {

        //if a query exists from Scout get the string
        $query = $request->input('query');

        //check if the query is empty if it isn't use the scout search method before paginating
        $collection = empty($query) ? Video::paginate(10) : Video::search($query)->paginate(10);

        return view('admin.partials.index_page.index', $this->videosRepository->indexElements(compact('collection')));
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        return view($this->videosRepository->getAdminFolderPath() . '.create');
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(VideoRequest $request, Video $video)
    {
        
        $video->create($request->all());
        
        return redirect('video');
    }
    
    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Video $video)
    {
        
        return view($this->videosRepository->getAdminFolderPath() . '.edit', compact('video'));
    }
    
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Video $video)
    {
        
        $video->update($request->all());
        
        return redirect('video');
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Video $video)
    {
        
        $video->delete();
        
        return redirect('video');
    }
}
