<?php namespace App\Http\Requests;

use App\Http\Requests\Request;

class ArticleRequest extends Request
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        return [
            'title'                             => 'required', //required to create an article
            'article_category_id'               => 'required', //required for blog - 6, magazine - 5, article - 1 required_if:article_type_id,6,5,1
            'article_magazine_edition_id'       => 'required_if:article_type_id,5', //required for magazine - 5
            'image_list.article.source'         => 'required_unless:published_at,,0000-00-00 00:00:00', //required if the article is being published
            'image_list.article.alternate_text' => 'required_unless:published_at,,0000-00-00 00:00:00', //required if the article is being published
            'article_author_id'                 => 'required_unless:published_at,,0000-00-00 00:00:00', //required if the article is being published
            'article_type_id'                   => 'required_unless:published_at,,0000-00-00 00:00:00', //required if the article is being published
            'content'                           => 'required_unless:published_at,,0000-00-00 00:00:00', //required if the article is being published
            'meta_keywords'                     => 'required_unless:published_at,,0000-00-00 00:00:00', //required if the article is being published
            'meta_description'                  => 'required_unless:published_at,,0000-00-00 00:00:00', //required if the article is being published
            'short_url'                         => 'unique:article_slug_redirects,slug',
            // 'job_link'                          => 'url',
        ];
    }
}
