<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PostedJobRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'company_name'      => 'required',
            'contact_full_name' => 'required',
            'contact_email'     => 'required_without:contact_telephone|email',
            'upload_logo'       => 'image',
            'job_ad_email'      => 'email',
            'job_ad_link'       => 'url',
            'youtube_link'      => 'url',
        ];
    }
}
