<?php

namespace App\Http\Requests;

use App\Subscriber;
use Auth;

class SubscriberRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        return [
            'email'                => (Auth::check() ? '' : 'required|email|') . 'unique:subscribers,email,' . (isset($this->subscriber) ? $this->subscriber->id : ''),
            'address_1'            => 'required_if:magazine,1',
            'city'                 => 'required_if:magazine,1',
            'subscriber_region_id' => 'required_if:country_id,840',
            'postal_code'          => 'required_if:magazine,1',
            'country_id'           => 'required_if:magazine,1',
        ];
    }

    public function messages()
    {
        return [
            'subscriber_region_id.required_if' => 'The State/Province field is required, if country is United States.',
        ];
    }

    public function withValidator($validator)
    {

        if ($validator->fails() && !empty($this->email)) {
            $subscriber = Subscriber::whereEmail($this->email)->first();

            if (Auth::check() && $subscriber) {
                redirect('/subscriber/' . $subscriber->id . '/edit')->send();
            } elseif ($subscriber) {
                redirect('/subscriber/send_subscriber_email')->send();
            }
        }
    }
}
