<?php

namespace App\Jobs;

use App\Banner;
use App\Marex\Reports\BannerReport;
use Auth;
use DB;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Log;
use Mail;

class CreateBannerReports implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    private $start_date;
    private $end_date;
    private $company;

    /**
     * Create a new job instance.
     *
     */
    public function __construct($start_date, $end_date, $company)
    {
        Log::info('Create Banner Report Job Started');

        $this->start_date = $start_date;
        $this->end_date   = $end_date;
        $this->company   = $company;

        Log::info('Handle Method');

        if (!empty($this->company)) {
            $banners = Banner::whereHas('newsletters', function ($query) {

                $query->where('official_date', '>=', $this->start_date)->where('official_date', '<=', $this->end_date);
            })->where('company', '=', $this->company)->get();
        } else {
            $banners = Banner::whereHas('newsletters', function ($query) {

                $query->where('official_date', '>=', $this->start_date)->where('official_date', '<=', $this->end_date);
            })->get();
        }

        $banner_report = new BannerReport();

        $banners->each(function ($banner) use ($banner_report) {

            $banner_excel_data = $banner_report->report($banner, $this->start_date, $this->end_date)->store('xls', storage_path('reports/banners'));

            // Mail::to($this->user)->send(new \App\Mail\BannerReport($banner_excel_data));
        });

        Log::info('Finished Banner Report');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        // Log::info('Handle Method');
        //
        // if (!empty($this->company)) {
        //     $banners = Banner::whereHas('newsletters', function ($query) {
        //
        //         $query->where('official_date', '>=', $this->start_date)->where('official_date', '<=', $this->end_date);
        //     })->where('company','=',$this->company)->get();
        // } else {
        //     $banners = Banner::whereHas('newsletters', function ($query) {
        //
        //         $query->where('official_date', '>=', $this->start_date)->where('official_date', '<=', $this->end_date);
        //     })->get();
        // }
        //
        // $banner_report = new BannerReport;
        //
        // $banners->each(function ($banner) use ($banner_report) {
        //
        //     $banner_excel_data = $banner_report->report($banner, $this->start_date, $this->end_date)->store('xls', storage_path('reports/banners'));
        //
        //     // Mail::to($this->user)->send(new \App\Mail\BannerReport($banner_excel_data));
        // });
        //
        // Log::info('Finished Banner Report');
    }
}
