<?php

namespace App\Jobs;

use App\Mail\MailingList;
use App\Repositories\MailingListRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Log;
use Mail;

class CreateMailingListExcelSheet implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $article_magazine_month_id, $year, $mailing_list_repository;
    private $printing;
    private $user;
    /**
     * @var
     */


    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($article_magazine_month_id, $year, $printing, $user)
    {
        $this->year  = $year;
        $this->mailing_list_repository = new MailingListRepository();
        $this->article_magazine_month_id = $article_magazine_month_id;
        $this->printing = $printing;
        $this->user = $user;

        Log::info('Started MailingList');

        $mailing_list_source = $this->mailing_list_repository->create_excel_mailing_list($this->article_magazine_month_id, $this->year, $this->printing);

        chmod($mailing_list_source, 0777);

        Mail::to($this->user->email)->send(new MailingList($mailing_list_source));

        Log::info('Finished MailingList');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
    }
}
