<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Log;
use Excel;
use App\SubscriberChange;

class ExportChangedDataExcelSheet implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $subscribers;
    /**
     * @var
     */


    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($subscribers)
    {
        $this->subscribers = $subscribers;

        Log::info('Started Excel');

        Excel::create('subsctibers_changes_' . date('m-d-Y'), function ($excel) use ($subscribers) {
            $excel->sheet('Subscribers', function ($sheet) use ($subscribers) {
                //setup the header titles
                $title_array = [
                    'Subscriber ID',
                    'Email',
                    'First Name',
                    'Last Name',
                    'Company',
                    'Address 1',
                    'Address 2',
                    'City',
                    'Postal Code',
                    'Region',
                    'Country',
                    'Source',
                    'Industry',
                    'Position Title',
                    'Position',
                    'Magazine',
                    'Digital',
                    'Newsletter',
                    'Email Marketing',
                ];

                $sheet->fromArray($title_array, null, 'A1');

                $subscribers->each(function ($subscriber, $key) use ($sheet) {

                    $key += 2;

                    $sheet->cell('A' . $key, $subscriber->id);
                    $sheet->cell('B' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->email);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'email')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('C' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->firstname);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'firstname')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('D' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->lastname);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'lastname')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('E' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->company);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'company')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('F' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->address_1);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'address_1')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('G' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->address_2);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'address_2')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('H' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->city);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'city')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('I' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->postal_code);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'postal_code')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('J' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->subscriberRegion ? $subscriber->subscriberRegion->name : $subscriber->region);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'region')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });

                    if (!is_object($subscriber->country) || is_null($subscriber->country)) {
                        $country_cell = '';
                    } elseif (!empty($subscriber->country->site_subscriber_translation)) {
                        $country_cell = $subscriber->country->site_subscriber_translation;
                    } else {
                        $country_cell = $subscriber->country->name;
                    }

                    $sheet->cell('K' . $key, function ($cell) use ($subscriber, $country_cell) {
                        $cell->setValue($country_cell);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'country_id')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('L' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue(is_null($subscriber->subscriberSource) ? '' : $subscriber->subscriberSource->name);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'subscriber_source_id')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('M' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue(is_null($subscriber->subscriberIndustry) ? '' : $subscriber->subscriberIndustry->name);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'subscriber_industry_id')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('N' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->position_title);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'position_title')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('O' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue(is_null($subscriber->subscriberPosition) ? '' : $subscriber->subscriberPosition->name);
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'subscriber_position_id')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('P' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue(($subscriber->magazine == 1) ? 'Subscribed' : 'Unsubscribed');
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'magazine')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('Q' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue(($subscriber->digital == 1) ? 'Subscribed' : 'Unsubscribed');
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'digital')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('R' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue(($subscriber->newsletter == 1) ? 'Subscribed' : 'Unsubscribed');
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'newsletter')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                    $sheet->cell('S' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue(($subscriber->email_marketing == 1) ? 'Subscribed' : 'Unsubscribed');
                        if (SubscriberChange::where('subscriber_id', '=', $subscriber->id)->where('column_name', '=', 'email_marketing')->first()) {
                            $cell->setFontColor('#a94442');
                        }
                    });
                });
            });
        })->download('xlsx');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
    }
}
