<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Log;
use Excel;

class ExportMailingListExcelSheet implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $subscribers;
    /**
     * @var
     */


    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($subscribers)
    {
        $this->subscribers = $subscribers;

        Log::info('Started Excel');

        Excel::create('mailing_list_' . date('m-d-Y'), function ($excel) use ($subscribers) {
            $excel->sheet('Subscribers', function ($sheet) use ($subscribers) {
                //setup the header titles
                $title_array = [
                    'Company Name',
                    'First Name',
                    'Last Name',
                    'Address 1',
                    'Address 2',
                    'City',
                    'Postal Code',
                    'Region',
                    'Country',
                ];

                $sheet->fromArray($title_array, null, 'A1');

                $subscribers->each(function ($subscriber, $key) use ($sheet) {

                    $key += 2;

                    $sheet->cell('A' . $key, $subscriber->company);
                    $sheet->cell('B' . $key, $subscriber->firstname);
                    $sheet->cell('C' . $key, $subscriber->lastname);
                    $sheet->cell('D' . $key, $subscriber->address_1);
                    $sheet->cell('E' . $key, $subscriber->address_2);
                    $sheet->cell('F' . $key, $subscriber->city);
                    $sheet->cell('G' . $key, $subscriber->postal_code);
                    $sheet->cell('H' . $key, function ($cell) use ($subscriber) {
                        $cell->setValue($subscriber->subscriberRegion ? $subscriber->subscriberRegion->name : $subscriber->region);
                    });

                    if (!is_object($subscriber->country) || is_null($subscriber->country)) {
                        $country_cell = '';
                    } elseif (!empty($subscriber->country->site_subscriber_translation)) {
                        $country_cell = $subscriber->country->site_subscriber_translation;
                    } else {
                        $country_cell = $subscriber->country->name;
                    }

                    $sheet->cell('I' . $key, $country_cell);
                });
            });
        })->download('xlsx');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
    }
}
