<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Article;
use Log;
use Analytics;
use Spatie\Analytics\Period;
use Carbon\Carbon;

class GetGaVews implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        Log::info('GetGaVews Job Started');

        $articles = Article::where('published_at', '<=', Carbon::now()->toDateTimeString())->where('published_at', '!=', '0000-00-00 00:00:00')->get();

        foreach ($articles as $article) {
            $articlelink = '/' . $article->articleType->slug . '/' . $article->slug;

            $analyticsData = Analytics::performQuery(
                Period::create(Carbon::now()->subYear(), Carbon::now()),
                'ga:users,ga:pageviews',
                [
                    'dimensions' => 'ga:date,ga:pageTitle',
                    'filters' => 'ga:pagePath=@' . $articlelink
                ]
            );

            $pageviewsData = collect($analyticsData['rows'] ?? [])->map(function (array $dateRow) {
                return (int) $dateRow[3];
            });

            $pageviews = 0;
            foreach ($pageviewsData as $page) {
                $pageviews += $page;
            }

            $article->views = $pageviews;
            $article->save();
        }

        Log::info('GetGaVews Job Ended');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
    }
}
