<?php

namespace App\Jobs;

use DB;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Log;
use Schema;
use App\Subscriber;

class ImportMailingListTable implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $filename;
    private $table_name;
    private $arr;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($filename, $table_name, $arr)
    {
        DB::disableQueryLog();

        //create the table if not exists
        if (!Schema::hasTable($table_name)) {
            Schema::create($table_name, function (\Illuminate\Database\Schema\Blueprint  $table) {
                $table->increments('id');
                $table->string('firstname');
                $table->string('lastname')->nullable();
                $table->string('company')->nullable();
                $table->string('address_1')->nullable();
                $table->string('address_2')->nullable();
                $table->string('city')->nullable();
                $table->string('region')->nullable();
                $table->string('postal_code')->nullable();
                $table->integer('country_id')->unsigned()->nullable();
                $table->string('email');
                $table->string('process_status')->nullable();
                $table->string('sent')->nullable();
                $table->string('date_added')->nullable();
                $table->integer('subscriber_industry_id')->nullable();
                $table->integer('subscriber_source_id')->nullable();
                $table->integer('subscriber_position_id')->nullable();
                $table->tinyInteger('magazine')->default('1')->nullable();
                $table->tinyInteger('digital')->default('0')->nullable();
                $table->date('start_date')->nullable();
                $table->date('end_date')->nullable();
                $table->timestamps();
            });
        }

        if (!empty($arr)) {
            foreach ($arr as $record) {
                if ($subscriber = Subscriber::whereEmail($record["email"])->first()) {
                    $record["subscriber_industry_id"] = $subscriber->subscriber_industry_id;
                    $record["subscriber_source_id"] = $subscriber->subscriber_source_id;
                    $record["subscriber_position_id"] = $subscriber->subscriber_position_id;
                    if (!isset($record["company"]) || $record["company"] == "") {
                        $record["company"] = $subscriber->company;
                    }
                }
                if ($record["id"] == null && !DB::table($table_name)->where('email', $record["email"])->exists()
                    && $subscriber = Subscriber::whereEmail($record["email"])->first()) {
                    $record["id"] = $subscriber->id;
                    $record["firstname"] = $subscriber->firstname;
                    $record["digital"] = '1';
                    $record["magazine"] = '0';
                    DB::table($table_name)->insertTs($record, true);

                    $recordfile["table_name"] = $table_name;
                    $recordfile["record_id"] = $record["id"];
                    $recordfile["file_name"] = $filename;
                    DB::table('mailing_list_file_name')->insertTs($recordfile, true);
                } elseif ($record["id"] == null && DB::table($table_name)->where('email', $record["email"])->exists()) {
                    DB::table($table_name)
                        ->where('email', $record["email"])
                        ->updateTs([
                            'process_status' => $record["process_status"],
                            'sent' => $record["sent"],
                            'date_added' => $record["date_added"],
                            'digital' => '1',
                        ], true);
                } elseif (DB::table($table_name)->where('id', $record["id"])->exists()) {
                    DB::table($table_name)
                        ->where('id', $record["id"])
                        ->updateTs($record, true);
                } elseif ($record["id"] != "") {
                    DB::table($table_name)->insertTs($record, true);
                    $recordfile["table_name"] = $table_name;
                    $recordfile["record_id"] = $record["id"];
                    $recordfile["file_name"] = $filename;
                    DB::table('mailing_list_file_name')->insertTs($recordfile, true);
                }
            }
        }
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
    }
}
