<?php

namespace App\Jobs;

use App\Repositories\MailingListRepository;
use DB;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Log;

class PopulateMailingListTable implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    private $article_magazine_month;
    private $year;
    private $printing;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($article_magazine_month, $year, $printing)
    {

        $this->article_magazine_month = $article_magazine_month;
        $this->year                   = $year;
        $this->printing               = $printing;

        $mailing_list_repository = new MailingListRepository();

        $table_name  = $mailing_list_repository->mailing_list_table_name($this->article_magazine_month, $this->year, $this->printing);
        $subscribers = $mailing_list_repository->mailing_list_subscribers($this->article_magazine_month, $this->year, $this->printing);

        DB::disableQueryLog();

        foreach ($subscribers->toArray() as $record) {
            DB::table($table_name)->insert($record);
        }
        // foreach (array_chunk($subscribers->toArray(), 1000) as $data_set) {
        //
        //     DB::table($table_name)->insert($data_set);
        // }
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
    }
}
