<?php

namespace App\Jobs;

use App\Repositories\SubscribersRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Log;

use App\Repositories\MailWizzRepository;
use MailWizzApi\Endpoint\ListSubscribers;
use App\Subscriber;

class SyncSubscribers implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * @var
     */

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        Log::info('Start Sync System.');

        $this->mailWizzRepository    = new MailWizzRepository('newsletter');
        $this->mailWizzDigitalRepository = new MailWizzRepository('digital');

        $newsletter_id = $this->mailWizzRepository->getListUid();
        $digital_id = $this->mailWizzDigitalRepository->getListUid();

        $endpoint = new ListSubscribers();

        $responsedigital = $endpoint->getSubscribers($digital_id, $pageNumber = 1, $perPage = 10);

        if ($responsedigital->body['status'] == 'success') {
            for ($i = 1; $i <= $responsedigital->body['data']['total_pages']; $i++) {
                $subresponse = $endpoint->getSubscribers($digital_id, $pageNumber = $i, $perPage = 10);
                foreach ($subresponse->body['data']['records'] as $item) {
                    if ($item["status"] == "confirmed") {
                        $status = 1;
                    } else {
                        $status = 0;
                    }
                    if ($subscriber = Subscriber::whereEmail($item["EMAIL"])->first()) {
                        if ($subscriber->digital != $status) {
                            $subscriber->update([
                                'digital' => $status
                            ]);
                        }
                    } else {
                        Subscriber::create([
                            'firstname' => $item["FNAME"],
                            'lastname' => $item["LNAME"],
                            'email' => $item["EMAIL"],
                            'newsletter' => 0,
                            'magazine' => 0,
                            'digital' => $status,
                            'email_marketing' => 0,
                            'subscriber_source_id' => 1,
                        ]);
                    }
                }
            }
        }

        $responsenewsletter = $endpoint->getSubscribers($newsletter_id, $pageNumber = 1, $perPage = 10);

        if ($responsenewsletter->body['status'] == 'success') {
            for ($i = 1; $i <= $responsenewsletter->body['data']['total_pages']; $i++) {
                $subresponse = $endpoint->getSubscribers($newsletter_id, $pageNumber = $i, $perPage = 10);
                foreach ($subresponse->body['data']['records'] as $item) {
                    if ($item["status"] == "confirmed") {
                        $status = 1;
                    } else {
                        $status = 0;
                    }
                    if ($subscriber = Subscriber::whereEmail($item["EMAIL"])->first()) {
                        if ($subscriber->newsletter != $status) {
                            $subscriber->update([
                                'newsletter' => $status
                            ]);
                        }
                    } else {
                        Subscriber::create([
                            'firstname' => $item["FNAME"],
                            'lastname' => $item["LNAME"],
                            'email' => $item["EMAIL"],
                            'newsletter' => $status,
                            'magazine' => 0,
                            'digital' => 0,
                            'email_marketing' => 0,
                            'subscriber_source_id' => 1,
                        ]);
                    }
                }
            }
        }

        Log::info('End Sync System.');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(SubscribersRepository $subscribersRepository)
    {
        //
    }
}
