<?php

namespace App\Jobs;

use App\Repositories\SubscribersRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Log;

class UpdateSubscriber implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * @var
     */
    private $subscriber;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($subscriber)
    {

        $this->subscriber = $subscriber;

        Log::info('__construct: Testing Que System.');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(SubscribersRepository $subscribersRepository)
    {

        //sync up the mailwizz lists based on the selected subscriptions
        $subscribersRepository->syncSubscriptionLists($this->subscriber);

        Log::info('handle: Testing Que System.');
    }
}
