<?php

namespace App\Jobs;

use App\Mail\SendSubscriberEmail;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Mail;
use Log;
use Request;

class UpdateSubscriberEmail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * @var
     */
    private $email, $logo, $link;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($email)
    {

        //log that the job has been queued.
        Log::info('__construct: Send Subscribers Email Job Queued. - ' . $email);

        $this->email = $email;
        $this->logo  = Request::root() . '/media/images/site/logo/marex_logo.png';
        $this->link  = Request::root() . '/subscriber/update_subscriber/' . encrypt($this->email);

        //log the start of the job
        Log::info('Send Subscribers Email Job Running sending to email - ' . $this->email);

        //send the email to the subscriber
        try {
            Log::info('Sending Email Now1');

            Mail::to($this->email)->send(new SendSubscriberEmail([
                                                                     'logo' => $this->logo,
                                                                     'link' => $this->link,
                                                                 ]));
            Log::info('Finished Sending Email');
        } catch (Exception $e) {
            Log::info('Error Occured');
            Log::info($e);
        }
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
    }
}
