<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class BannerReport extends Mailable
{
    use Queueable, SerializesModels;
    private $banner_excel_data;
    private $email_title;
    private $email_body;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($banner_excel_data, $email_title, $email_body)
    {

        $this->banner_excel_data = $banner_excel_data;
        $this->email_title = $email_title;
        $this->email_body = $email_body;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $email = $this->view('emails.banner_report')->subject($this->email_title)->text($this->email_body);

        // $attachments is an array with file paths of attachments
        foreach ($this->banner_excel_data as $filePath) {
            $email->attach(storage_path('reports/banners/' . $filePath));
        }

        return $email;
    }
}
