<?php

namespace App\Mail;

use Request;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Log;

class Contact extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var
     */
    public $name, $email, $phone, $comment, $country, $type, $logo;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($content)
    {

        $this->name    = $content['firstname'] . ' ' . $content['lastname'];
        $this->email   = $content['email'];
        $this->phone   = $content['phone'];
        $this->comment = $content['comment'];
        $this->country = $content['country'];
        $this->type    = $content['type'];
        $this->logo    = $content['logo'];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {

        return $this->view('emails.contact');
    }
}
