<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class ExportApproved extends Mailable
{
    use Queueable, SerializesModels;
    private $username;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($username)
    {
        $this->username = $username;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $email = $this->view('emails.export_approved')->subject('Excel Download Request')
                    ->with([
                        'username' => $this->username,
                        'approveUrl' => url(route('subscriber/admin')),
                    ]);

        return $email;
    }
}
