<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;

class ExportRequest extends Mailable
{
    use Queueable, SerializesModels;
    private $user;
    private $requestId;
    private $email;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user, $requestId, $email)
    {
        $this->user = $user;
        $this->email = $email;
        $this->requestId = $requestId;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $email = $this->view('emails.export_request')->subject('Excel Download Request')
                    ->with([
                        'user' => $this->user,
                        'approveUrl' => url(route('subscriber/approve', ['id' => $this->requestId,'email' => $this->email])),
                        'disapproveUrl' => url(route('subscriber/disapprove', ['id' => $this->requestId,'email' => $this->email])),
                    ]);

        return $email;
    }
}
