<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Log;

class MailingList extends Mailable
{
    use Queueable, SerializesModels;
    private $attachement_source;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($attachement_source)
    {
        //excel sheet attachment source
        $this->attachement_source = $attachement_source;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.mailing_list')
                    ->attach($this->attachement_source);
    }
}
