<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Log;

class SendSubscriberEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var
     */
    private $link, $logo;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($content)
    {

        $this->logo = $content['logo'];
        $this->link = $content['link'];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {

        $this->subject('Verification Email');

        return $this->view('emails.update_subscriber_email', ['logo' => $this->logo, 'link' => $this->link]);
    }
}
