<?php

namespace App\Mail;

use App\Newsletter;
use App\Repositories\NewslettersRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendTestNewsletter extends Mailable
{
    use Queueable, SerializesModels;
    private $newsletter_id;

    /**
     * @var NewslettersRepository
     */
    private $newsletters_repository;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($newsletter_id)
    {

        $this->newsletter_id          = $newsletter_id;
        $this->newsletters_repository = new NewslettersRepository();
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {

        $newsletter      = Newsletter::findOrFail($this->newsletter_id);

        $newsletter_data = $this->newsletters_repository->NewsletterTemplateBlock(['newsletter_id' => $newsletter->id]);

        $this->subject('TESTING: ' . $newsletter->subject);
        
        $this->from('no-reply@maritime-executive.com', 'The Maritime Executive Newsletter');

        return $this->view('newsletters.index', $newsletter_data);
    }
}
