<?php

namespace App\Marex\Reports;


use App\Article;
use Excel;
use DB;
use PHPExcel_RichText;
use PHPExcel_Shared_Font;
use PHPExcel_Style_Alignment;
use PHPExcel_Style_Border;
use PHPExcel_Style_Fill;
use PHPExcel_Style_NumberFormat;
use PHPExcel_Worksheet_Drawing;

class ArticleReport
{

    public function report($slug)
    {

        return Excel::create('Article Report', function ($excel) use ($slug) {

            /**
             * queries required for excel sheet
             */
            $article = Article::whereSlug($slug)->first();

            $campaign_ids = DB::connection('newsletter')
                              ->table('mw_campaign_url')
                              ->select('campaign_id')
                              ->where(function ($query) use ($article) {

                                  $query->orWhere('destination', 'LIKE', '%' . $article->slug . '%');

                                if ($article->articleSlugRedirect->isNotEmpty()) {
                                    $article->articleSlugRedirect->each(function ($redirect) use (&$query) {

                                        $query->orWhere('destination', 'LIKE', '%' . $redirect->slug . '%');
                                    });
                                }
                              })
                              ->groupBy('campaign_id')
                              ->pluck('campaign_id')->toArray();

            //total opens
            $mailiwzz_newsletter = DB::connection('newsletter')
                                     ->table('mw_campaign_track_open AS mcto')
                                     ->select(DB::raw('COUNT(mcto.campaign_id) newsletter_total_clicks, mc.campaign_uid'))
                                     ->join('mw_campaign AS mc', 'mc.campaign_id', 'mcto.campaign_id')
                                     ->whereIn('mcto.campaign_id', $campaign_ids)
                                     ->groupBy('mcto.campaign_id')
                                     ->get()
                                     ->keyBy('campaign_uid');

            $mailwizz_article = DB::connection('newsletter')
                                  ->table('mw_campaign AS mc')
                                  ->select('mc.campaign_uid', 'mls.email')
                                  ->join('mw_campaign_url AS mcu', 'mcu.campaign_id', 'mc.campaign_id')
                                  ->join('mw_campaign_track_url AS mctu', 'mctu.url_id', 'mcu.url_id')
                                  ->join('mw_list_subscriber AS mls', 'mls.subscriber_id', 'mctu.subscriber_id')
                                  ->where(function ($query) use ($article) {

                                      $query->orWhere('mcu.destination', 'LIKE', '%' . $article->slug . '%');

                                    if ($article->articleSlugRedirect->isNotEmpty()) {
                                        $article->articleSlugRedirect->each(function ($redirect) use (&$query) {

                                            $query->orWhere('mcu.destination', 'LIKE', '%' . $redirect->slug . '%');
                                        });
                                    }
                                  })
                                  ->get()
                                  ->groupBy('campaign_uid');

            /**
             *
             * Campaign Stats Sheet
             *
             */
            $excel->sheet('Campaign Stats', function ($sheet) use ($article, $mailwizz_article, $mailiwzz_newsletter) {

                /**
                 * FIELDS
                 */

                /**
                 * STYLE ITEMS
                 */

                //make the entire page have a white background
                $styleArray = [
                    'fill' => [
                        'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => ['rgb' => 'FFFFFF'],
                    ],
                ];

                $styleArray_background_grey = [
                    'fill' => [
                        'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => ['rgb' => 'F5F5F5'],
                    ],
                ];

                $styleArray_BoldText = [
                    'font' => [
                        'bold' => true,
                    ],
                ];

                $BStyle_thin = [
                    'borders' => [
                        'outline' => [
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                        ],
                    ],
                ];

                $BStyle_bottom_double = [
                    'borders' => [
                        'bottom' => [
                            'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
                        ],
                    ],
                ];

                //apply defautl styling
                $sheet->getDefaultStyle()->applyFromArray($styleArray);

                /**
                 * adding the marex logo to the top left of the sheet
                 */

                $objDrawing = new PHPExcel_Worksheet_Drawing();
                $objDrawing->setPath('media/images/site/logo/marex_logo.png');
                $objDrawing->setCoordinates('A1');
                $objDrawing->setHeight(92);
                $objDrawing->setWorkSheet($sheet);

                //set width of A so if the report is empty nothing is squished
                $sheet->setWidth('A', 41);

                //Title: Campaign Overview
                $sheet->cell('A12', 'Article Campaign Stats')->getStyle('A12')->applyFromArray($styleArray_BoldText)->getFont()->setSize(14);

                //Total Sendout
                $sendout_total_text = new PHPExcel_RichText();
                $sendout_total_bold = $sendout_total_text->createTextRun('Total Sendout: ');
                $sendout_total_bold->getFont()->setBold(true);
                $sendout_total_text->createText('104294');

                $shares_total_text = new PHPExcel_RichText();
                $shares_total_bold = $shares_total_text->createTextRun('Shares: ');
                $shares_total_bold->getFont()->setBold(true);
                $shares_total_text->createText('');

                $sheet->cell('A13', $sendout_total_text);
                // $sheet->cell('A14', $shares_total_text);

                //Company Address Section
                $sheet->mergeCells('A1:F1')->cell('A1', '3200 S. Andrews Ave., Suite 100');
                $sheet->mergeCells('A2:F2')->cell('A2', 'Ft. Lauderdale, FL 33316');
                $sheet->mergeCells('A3:F3')->cell('A3', 'Phone: +1(954) 848-9955');
                $sheet->mergeCells('A4:F4')->cell('A4', 'Fax: +1(954) 848-9948');
                $sheet->mergeCells('A5:F5')->cell('A5', 'www.maritime-executive.com');

                $sheet->mergeCells('A7:F7')->cell('A7', date('F j, Y'));

                $sheet->cells('A1:A7', function ($cells) {

                    $cells->setAlignment('right');
                });

                $sheet->cell('A15', 'URL');
                $sheet->cell('B15', 'Sendout Date');
                $sheet->cell('C15', 'Total Impressions');
                $sheet->cell('D15', 'Clicks');
                $sheet->cell('E15', 'CTR');
                $sheet->cell('F15', 'Views');

                /**
                 * Apply more global styling
                 */

                //styling links header
                $sheet->getStyle('A15:F15')->applyFromArray($styleArray_BoldText);
                $sheet->getStyle('A15:F15')->applyFromArray($BStyle_thin);
                $sheet->getStyle('A15:F15')->applyFromArray($BStyle_bottom_double);
                $sheet->getStyle('A15:F15')->applyFromArray($styleArray_background_grey);

                /**
                 * add in the list of links, total clicks, and CTR
                 */

                $row_count = 16;

                foreach ($article->newsletters as $newsletter) {
                    if ($newsletter->campaign_uid && isset($mailiwzz_newsletter[$newsletter->campaign_uid])) {
                        $official_date           = $newsletter->official_date;
                        $article_total_clicks    = $mailwizz_article[$newsletter->campaign_uid]->count();
                        $newsletter_total_clicks = $mailiwzz_newsletter[$newsletter->campaign_uid]->newsletter_total_clicks;
                        $article_link            = $article->link;
                        $article_views           = $article->views;
                        //Link
                        $sheet->cell('A' . $row_count, $article_link)->getColumnDimension('A')->setAutoSize(true);

                        //Total Newsletter Impressions
                        $sheet->cell('B' . $row_count, $official_date)->getColumnDimension('B')->setAutoSize(true);

                        //Official Date
                        $sheet->cell('C' . $row_count, number_format($newsletter_total_clicks))->getColumnDimension('C')->setAutoSize(true);

                        //Clicks
                        $sheet->cell('D' . $row_count, number_format($article_total_clicks))->getColumnDimension('D')->setAutoSize(true);

                        //CTR and set the CTR to show as a percentage
                        $sheet->cell('E' . $row_count, $article_total_clicks / $newsletter_total_clicks)->setAutoSize(true)->getStyle('E' . $row_count)->getNumberFormat()->applyFromArray(['code' => PHPExcel_Style_NumberFormat::FORMAT_PERCENTAGE_00]);

                        // Views count
                        $sheet->cell('F' . $row_count, $article_views)->getColumnDimension('F')->setAutoSize(true);

                        //set row left justified
                        $sheet->getStyle('A' . $row_count . ':F' . $row_count)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

                        //add a thin border around the links
                        $sheet->getStyle('A' . $row_count . ':F' . $row_count)->applyFromArray($BStyle_thin);

                        $row_count++;
                    }
                }
            });

            /**
             *
             * Email Stats Sheet
             *
             */

            $excel->sheet('Email Stats', function ($sheet) use ($article, $mailwizz_article) {


                if ($mailwizz_article->isNotEmpty()) {

                    /**
                     * STYLE ITEMS
                     */

                    $styleArray_background_grey = [
                        'fill' => [
                            'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => 'D3D3D3'],
                        ],
                    ];

                    /**
                     * list each link and the emails that clicked on it (unique emails)
                     */

                    $newsletters = $article->newsletters->keyBy('campaign_uid');

                    $column = 'A';

                    foreach ($mailwizz_article as $campaign_uid => $campaign) {
                        if (isset($newsletters[$campaign_uid])) {
                            $email_count = 1;

                            $sheet->cell($column . $email_count, $newsletters[$campaign_uid]->official_date)->getStyle($column . $email_count)->applyFromArray($styleArray_background_grey);

                            $email_count++;

                            foreach ($campaign as $key => $subscriber) {
                                $sheet->cell($column . $email_count, $subscriber->email);

                                $email_count++;
                            }

                            $column++;
                        }
                    }
                }
            });

            $excel->setActiveSheetIndex(0);
        })->download('xlsx');
    }
}
